/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBSqlParser {
    private static Pattern s_sqlSelectPattern = Pattern.compile("select(.*) from(.*)", 10);
    private static Pattern s_sqlSelectPatternWithWhere = Pattern.compile("select(.*) from(.*) where(.*)", 10);
    private static Pattern s_sqlSelectPatternWithOrderBy = Pattern.compile("select(.*) from(.*) order by(.*)", 10);
    private static Pattern s_sqlSelectPatternWithWhereAndOrderBy = Pattern.compile("select(.*) from(.*) where(.*) order by(.*)", 10);
    private String m_sql;
    private String m_table;
    private String[] m_fields;
    private String m_filter;
    private String m_orderBy;

    public DBSqlParser(String sql) {
        this.m_sql = sql;
        if (this.m_sql == null) {
            this.m_table = "";
            this.m_filter = "";
            this.m_orderBy = "";
            return;
        }
        if (this.m_sql.toUpperCase().startsWith("SELECT")) {
            this.matchSqlSelect();
        }
    }

    private void matchSqlSelect() {
        Matcher matcher = s_sqlSelectPatternWithWhereAndOrderBy.matcher(this.m_sql);
        if (matcher.matches() && matcher.groupCount() == 4) {
            this.m_fields = matcher.group(1).trim().replaceAll(" ", "").split(",");
            this.m_table = matcher.group(2).trim();
            this.m_filter = matcher.group(3).trim();
            this.m_orderBy = matcher.group(4).trim();
            return;
        }
        matcher = s_sqlSelectPatternWithOrderBy.matcher(this.m_sql);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.m_fields = matcher.group(1).trim().replaceAll(" ", "").split(",");
            this.m_table = matcher.group(2).trim();
            this.m_filter = null;
            this.m_orderBy = matcher.group(3).trim();
            return;
        }
        matcher = s_sqlSelectPatternWithWhere.matcher(this.m_sql);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.m_fields = matcher.group(1).trim().replaceAll(" ", "").split(",");
            this.m_table = matcher.group(2).trim();
            this.m_filter = matcher.group(3).trim();
            this.m_orderBy = null;
            return;
        }
        matcher = s_sqlSelectPattern.matcher(this.m_sql);
        if (matcher.matches() && matcher.groupCount() == 2) {
            this.m_fields = matcher.group(1).trim().replaceAll(" ", "").split(",");
            this.m_table = matcher.group(2).trim();
            this.m_filter = null;
            this.m_orderBy = null;
            return;
        }
        throw new RuntimeException("DbSqlParser: Unable to parse SQL: " + this.m_sql);
    }

    public String getTable() {
        return this.m_table;
    }

    public String[] getFields() {
        return this.m_fields;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    public String getSQL() {
        return this.m_sql;
    }
}

