/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import fit.ActionFixture;
import java.sql.Connection;
import java.sql.DriverManager;

public class DatabaseCompareConnFixture
extends ActionFixture {
    private static DatabaseCompareConnFixture s_configurationFixture;
    private String m_sourceDbUrl;
    private String m_sourceDbUser;
    private String m_sourceDbPass;
    private String m_targetDbUrl;
    private String m_targetDbUser;
    private String m_targetDbPass;
    private static String m_sourcedbtype;
    private static String m_targetdbtype;
    private Connection m_sourceConnect;
    private Connection m_targetConnect;

    public DatabaseCompareConnFixture() {
        if (s_configurationFixture == null) {
            s_configurationFixture = this;
        }
    }

    public void setSourceString(String source) {
        this.m_sourceDbUrl = source;
    }

    public void setSourceDbUser(String dbUser) {
        this.m_sourceDbUser = dbUser;
    }

    public void setSourceDbPassword(String dbPassword) {
        this.m_sourceDbPass = dbPassword;
    }

    public void setTargetString(String target) {
        this.m_targetDbUrl = target;
    }

    public void setTargetDbUser(String dbUser) {
        this.m_targetDbUser = dbUser;
    }

    public void setTargetDbPassword(String dbPassword) {
        this.m_targetDbPass = dbPassword;
    }

    public static void setSourceDbType(String dbType) {
        m_sourcedbtype = dbType;
    }

    public static void setTourceDbType(String dbType) {
        m_targetdbtype = dbType;
    }

    public static Connection setconnection(String dbUrl, String dbUser, String dbPassword) throws Exception {
        String connectionUrl = dbUrl;
        Class.forName("oracle.jdbc.OracleDriver");
        Connection con = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        return con;
    }

    private void createSourceConnection() {
        try {
            this.m_sourceConnect = DatabaseCompareConnFixture.setconnection(this.m_sourceDbUrl, this.m_sourceDbUser, this.m_sourceDbPass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createTargetConnection() {
        try {
            this.m_targetConnect = DatabaseCompareConnFixture.setconnection(this.m_targetDbUrl, this.m_targetDbUser, this.m_targetDbPass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getSource() {
        return this.m_sourceConnect;
    }

    public Connection getTarget() {
        return this.m_targetConnect;
    }

    public boolean setUp() {
        this.createSourceConnection();
        this.createTargetConnection();
        return true;
    }

    public boolean tearDown() {
        if (s_configurationFixture != null) {
            if (DatabaseCompareConnFixture.s_configurationFixture.m_sourceConnect != null) {
                try {
                    DatabaseCompareConnFixture.s_configurationFixture.m_sourceConnect.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (DatabaseCompareConnFixture.s_configurationFixture.m_targetConnect != null) {
                try {
                    DatabaseCompareConnFixture.s_configurationFixture.m_targetConnect.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            s_configurationFixture = null;
        }
        return true;
    }

    public static DatabaseCompareConnFixture getInstance() {
        return s_configurationFixture;
    }
}

