/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.c;

public final class UnsyncHashtable
extends Dictionary
implements Serializable,
Cloneable {
    private transient a[] a;
    private transient int b;
    private int c;
    private float d;

    public UnsyncHashtable(int n, float f2) {
        if (n <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.d = f2;
        this.a = new a[n];
        this.c = (int)((float)n * f2);
    }

    public UnsyncHashtable(int n) {
        this(n, 0.75f);
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public boolean isEmpty() {
        return this.b == 0;
    }

    public Enumeration keys() {
        return new b(this.a, true);
    }

    public Enumeration elements() {
        return new b(this.a, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        a[] aArray = this.a;
        int n = aArray.length;
        while (n-- > 0) {
            a a2 = aArray[n];
            while (a2 != null) {
                if (a2.c.equals(object)) {
                    return true;
                }
                a2 = a2.d;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        a[] aArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n2];
        while (a2 != null) {
            if (a2.a == n && a2.b.equals(object)) {
                return true;
            }
            a2 = a2.d;
        }
        return false;
    }

    public Object get(Object object) {
        a[] aArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n2];
        while (a2 != null) {
            if (a2.a == n && a2.b.equals(object)) {
                return a2.c;
            }
            a2 = a2.d;
        }
        return null;
    }

    protected void a() {
        int n = this.a.length;
        a[] aArray = this.a;
        int n2 = n * 2 + 1;
        a[] aArray2 = new a[n2];
        this.c = (int)((float)n2 * this.d);
        this.a = aArray2;
        int n3 = n;
        while (n3-- > 0) {
            a a2 = aArray[n3];
            while (a2 != null) {
                a a3 = a2;
                a2 = a2.d;
                int n4 = (a3.a & Integer.MAX_VALUE) % n2;
                a3.d = aArray2[n4];
                aArray2[n4] = a3;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        a[] aArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n2];
        while (a2 != null) {
            if (a2.a == n && a2.b.equals(object)) {
                Object object3 = a2.c;
                a2.c = object2;
                return object3;
            }
            a2 = a2.d;
        }
        if (this.b >= this.c) {
            this.a();
            return this.put(object, object2);
        }
        a2 = new a(null);
        a2.a = n;
        a2.b = object;
        a2.c = object2;
        a2.d = aArray[n2];
        aArray[n2] = a2;
        ++this.b;
        return null;
    }

    public Object remove(Object object) {
        a[] aArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n2];
        a a3 = null;
        while (a2 != null) {
            if (a2.a == n && a2.b.equals(object)) {
                if (a3 != null) {
                    a3.d = a2.d;
                } else {
                    aArray[n2] = a2.d;
                }
                --this.b;
                return a2.c;
            }
            a3 = a2;
            a2 = a2.d;
        }
        return null;
    }

    public void clear() {
        a[] aArray = this.a;
        int n = aArray.length;
        while (--n >= 0) {
            aArray[n] = null;
        }
        this.b = 0;
    }

    public Object clone() {
        try {
            UnsyncHashtable unsyncHashtable = (UnsyncHashtable)super.clone();
            unsyncHashtable.a = new a[this.a.length];
            int n = this.a.length;
            while (n-- > 0) {
                unsyncHashtable.a[n] = this.a[n] != null ? (a)this.a[n].clone() : null;
            }
            return unsyncHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.writeInt(this.b);
        for (int i = this.a.length - 1; i >= 0; --i) {
            a a2 = this.a[i];
            while (a2 != null) {
                objectOutputStream.writeObject(a2.b);
                objectOutputStream.writeObject(a2.c);
                a2 = a2.d;
            }
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.d) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.a = new a[n3];
        this.b = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    private class b
    implements Enumeration {
        boolean a;
        int b;
        a[] c;
        a d;

        b(a[] aArray, boolean bl) {
            this.c = aArray;
            this.a = bl;
            this.b = aArray.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.d != null) {
                return true;
            }
            while (this.b-- > 0) {
                this.d = this.c[this.b];
                if (this.d == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.d == null) {
                while (this.b-- > 0 && (this.d = this.c[this.b]) == null) {
                }
            }
            if (this.d != null) {
                a a2 = this.d;
                this.d = a2.d;
                return this.a ? a2.b : a2.c;
            }
            throw new NoSuchElementException("UnsyncHashtableEnumerator");
        }
    }

    private class a {
        int a;
        Object b;
        Object c;
        a d;

        private a() {
        }

        protected Object clone() {
            a a2 = new a();
            a2.a = this.a;
            a2.b = this.b;
            a2.c = this.c;
            a2.d = this.d != null ? (a)this.d.clone() : null;
            return a2;
        }

        /* synthetic */ a(c c2) {
            this();
        }
    }
}

