/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleDriver;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class TestingConnection {
    private static Connection m_conn = null;
    private static Connection m_targetConn = null;
    private static DatabaseConnection m_dbconn = null;
    private static DatabaseConnection m_dbtargetConn = null;
    private static String m_sUser = null;
    private static String m_sPassword = null;
    private static String m_url = null;
    private static String m_targeturl = null;
    private static ServerType m_serverType = ServerType.SQLSERVER;
    private static ServerType m_targetServerType = ServerType.SQLSERVER;
    private static boolean m_bUseAdmuser = false;

    private static void initSettings() throws PrimaveraDatabaseException {
        if (!(m_url != null && m_url.trim().length() != 0 || (m_url = System.getProperty("db.tools.url")) != null && m_url.trim().length() != 0)) {
            m_url = null;
        }
        if (m_url == null) {
            throw new PrimaveraDatabaseException("TestingConnection.Connect(): No url for connection");
        }
        m_serverType = TestingConnection.serverTypeFromUrl(m_url);
        String admuserName = null;
        String admuserPass = null;
        if (m_serverType == ServerType.ORACLE) {
            admuserName = "admuser";
            admuserPass = "admuser";
        } else if (m_serverType == ServerType.SQLSERVER) {
            admuserName = "sa";
            admuserPass = "dbteam";
        } else {
            admuserName = "exp";
            admuserPass = "sql";
        }
        if (!m_bUseAdmuser) {
            if (!(m_sUser != null && m_sUser.trim().length() != 0 || (m_sUser = System.getProperty("db.user.privusername")) != null && m_sUser.trim().length() != 0)) {
                m_sUser = "privuser";
            }
            if (!(m_sPassword != null && m_sPassword.trim().length() != 0 || (m_sPassword = System.getProperty("db.user.privuserpass")) != null && m_sPassword.trim().length() != 0)) {
                m_sPassword = "privuser";
            }
        } else {
            m_sUser = admuserName;
            m_sPassword = admuserPass;
        }
    }

    private static void Connect() throws SQLException, PrimaveraDatabaseException {
        TestingConnection.initSettings();
        try {
            if (m_serverType == ServerType.ORACLE) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            } else if (m_serverType == ServerType.SQLSERVER) {
                DriverManager.registerDriver((Driver)new SQLServerDriver());
            }
            m_conn = DriverManager.getConnection(m_url, m_sUser, m_sPassword);
        }
        catch (SQLException e) {
            System.out.println("Connection fail: " + e.getMessage());
            System.out.println("Url: " + m_url);
            System.out.println("Password: " + m_sUser);
            System.out.println("Url: " + m_sPassword);
            if (m_serverType == ServerType.ORACLE) {
                System.out.println("Server: Oracle");
            } else if (m_serverType == ServerType.SQLSERVER) {
                System.out.println("Server: SQL Server");
            } else {
                System.out.println("Server: Sybase");
            }
            throw e;
        }
    }

    private static void initTargetSettings() throws PrimaveraDatabaseException {
        if (!(m_targeturl != null && m_targeturl.trim().length() != 0 || (m_targeturl = System.getProperty("db.tools.targeturl")) != null && m_targeturl.trim().length() != 0)) {
            m_targeturl = null;
        }
        if (m_targeturl == null) {
            throw new PrimaveraDatabaseException("TestingConnection.Connect(): No url for target connection");
        }
        m_targetServerType = TestingConnection.serverTypeFromUrl(m_targeturl);
        String admuserName = null;
        String admuserPass = null;
        if (m_targetServerType == ServerType.ORACLE) {
            admuserName = "admuser";
            admuserPass = "admuser";
        } else if (m_targetServerType == ServerType.SQLSERVER) {
            admuserName = "sa";
            admuserPass = "dbteam";
        } else {
            admuserName = "exp";
            admuserPass = "sql";
        }
        if (!m_bUseAdmuser) {
            if (!(m_sUser != null && m_sUser.trim().length() != 0 || (m_sUser = System.getProperty("db.user.privusername")) != null && m_sUser.trim().length() != 0)) {
                m_sUser = "privuser";
            }
            if (!(m_sPassword != null && m_sPassword.trim().length() != 0 || (m_sPassword = System.getProperty("db.user.privuserpass")) != null && m_sPassword.trim().length() != 0)) {
                m_sPassword = "privuser";
            }
        } else {
            m_sUser = admuserName;
            m_sPassword = admuserPass;
        }
    }

    private static void targetConnect() throws SQLException, PrimaveraDatabaseException {
        TestingConnection.initTargetSettings();
        if (m_targetServerType == ServerType.ORACLE) {
            DriverManager.registerDriver((Driver)new OracleDriver());
            m_targetConn = DriverManager.getConnection(m_targeturl, m_sUser, m_sPassword);
        } else if (m_targetServerType == ServerType.SQLSERVER) {
            DriverManager.registerDriver((Driver)new SQLServerDriver());
            m_targetConn = DriverManager.getConnection(m_targeturl, m_sUser, m_sPassword);
        } else if (m_targetServerType == ServerType.SYBASE) {
            // empty if block
        }
    }

    public static Connection getConnection() throws PrimaveraDatabaseException {
        try {
            if (m_conn == null || m_conn.isClosed()) {
                TestingConnection.Connect();
            }
            return m_conn;
        }
        catch (SQLException e) {
            throw new PrimaveraDatabaseException(e.getMessage());
        }
    }

    public static DatabaseConnection getDatabaseConnection() throws PrimaveraDatabaseException {
        if (m_dbconn == null) {
            Connection conn = TestingConnection.getConnection();
            m_dbconn = new DatabaseConnection();
            m_dbconn.setConnection(conn, m_serverType);
        }
        return m_dbconn;
    }

    public static Connection getTargetConnection() throws PrimaveraDatabaseException {
        try {
            if (m_targetConn == null || m_targetConn.isClosed()) {
                TestingConnection.targetConnect();
            }
            return m_targetConn;
        }
        catch (SQLException e) {
            throw new PrimaveraDatabaseException(e.getMessage());
        }
    }

    public static DatabaseConnection getTargetDatabaseConnection() throws PrimaveraDatabaseException {
        try {
            if (m_dbtargetConn == null || m_dbtargetConn.getConnection().isClosed()) {
                Connection conn = TestingConnection.getTargetConnection();
                m_dbtargetConn = new DatabaseConnection();
                m_dbtargetConn.setConnection(conn, m_targetServerType);
            }
            return m_dbtargetConn;
        }
        catch (SQLException e) {
            throw new PrimaveraDatabaseException(e.getMessage());
        }
    }

    private static ServerType serverTypeFromUrl(String url) {
        if (url.indexOf("oracle") > 0) {
            return ServerType.ORACLE;
        }
        if (url.contains("sybase")) {
            return ServerType.SYBASE;
        }
        return ServerType.SQLSERVER;
    }

    public static ServerType getServerType() {
        return m_serverType;
    }

    public static ServerType getTargetServerType() {
        return m_targetServerType;
    }

    public static void setUseAdmuser(boolean b) {
        m_bUseAdmuser = b;
        m_sUser = null;
        m_sPassword = null;
        try {
            if (m_targetConn != null && m_targetConn.isClosed()) {
                m_targetConn.close();
            }
            if (m_conn != null && m_conn.isClosed()) {
                m_conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getUrl() {
        return m_url;
    }

    public static String getTargetUrl() {
        return m_targeturl;
    }

    public static String getUsername() {
        return m_sUser;
    }

    public static String getPassword() {
        return m_sPassword;
    }
}

