/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.ServerType;

public final class DatabaseSyntaxHelper {
    public static String getPhysicalDataType(GenericDataTypes gendatatype, ServerType servertype) {
        String datatype = null;
        if (servertype == ServerType.ORACLE) {
            switch (gendatatype) {
                case INTEGER: 
                case DOUBLE: 
                case TINYINT: 
                case SMALLINT: 
                case NUMBER: {
                    datatype = "number";
                    break;
                }
                case CHARACTER: 
                case OCHARACTER: 
                case STRING: 
                case NVARCHAR: {
                    datatype = "varchar2";
                    break;
                }
                case TIMESTAMP: 
                case DATE: {
                    datatype = "date";
                    break;
                }
                case MEMO: 
                case CLOB: 
                case IMAGE: 
                case BLOB: {
                    datatype = "blob";
                }
            }
        } else if (servertype == ServerType.SQLSERVER) {
            switch (gendatatype) {
                case INTEGER: {
                    datatype = "integer";
                    break;
                }
                case DOUBLE: 
                case NUMBER: {
                    datatype = "decimal";
                    break;
                }
                case TINYINT: {
                    datatype = "tinyint";
                    break;
                }
                case SMALLINT: {
                    datatype = "smallint";
                    break;
                }
                case CHARACTER: 
                case OCHARACTER: 
                case STRING: 
                case NVARCHAR: {
                    datatype = "varchar";
                    break;
                }
                case TIMESTAMP: 
                case DATE: {
                    datatype = "datetime";
                    break;
                }
                case MEMO: 
                case CLOB: 
                case BLOB: {
                    datatype = "text";
                    break;
                }
                case IMAGE: {
                    datatype = "image";
                }
            }
        } else if (servertype == ServerType.SYBASE) {
            switch (gendatatype) {
                case INTEGER: {
                    datatype = "integer";
                    break;
                }
                case DOUBLE: 
                case NUMBER: {
                    datatype = "numeric";
                    break;
                }
                case TINYINT: {
                    datatype = "tinyint";
                    break;
                }
                case SMALLINT: {
                    datatype = "smallint";
                    break;
                }
                case CHARACTER: 
                case OCHARACTER: 
                case STRING: {
                    datatype = "varchar";
                    break;
                }
                case TIMESTAMP: {
                    datatype = "timestamp";
                    break;
                }
                case DATE: {
                    datatype = "date";
                    break;
                }
                case MEMO: 
                case CLOB: 
                case IMAGE: 
                case BLOB: {
                    datatype = "image";
                }
            }
        }
        return datatype;
    }
}

