/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.VersionQueryNotFound;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SchemaInfoImpl
implements SchemaInfo {
    private static Map<SchemaType, Map<ServerType, String>> s_versionQueryMap = new HashMap<SchemaType, Map<ServerType, String>>();
    private SchemaType m_product;
    private ProductVersion m_version;

    private SchemaInfoImpl(SchemaType product, int majorVersion, int minorVersion, int releaseVersion) {
        this.m_product = product;
        this.m_version = new ProductVersion(majorVersion, minorVersion, releaseVersion);
    }

    public int hashCode() {
        long hash = this.m_version.hashCode();
        return (int)((hash += (long)this.m_product.hashCode()) % Integer.MAX_VALUE);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchemaInfo) {
            SchemaInfo schema = (SchemaInfo)obj;
            ProductVersion version = new ProductVersion(schema.getMajVersion(), schema.getMinVersion(), schema.getRelVersion());
            boolean areEqual = this.m_product.equals((Object)schema.getSchemaType()) && this.m_version.equals(version);
            return areEqual;
        }
        return false;
    }

    @Override
    public int compareTo(SchemaInfo schema) {
        if (this.m_product.equals((Object)schema.getSchemaType())) {
            ProductVersion version = new ProductVersion(schema.getMajVersion(), schema.getMinVersion(), schema.getRelVersion());
            return this.m_version.compareTo(version);
        }
        return this.m_product.compareTo(schema.getSchemaType());
    }

    public static SchemaInfoImpl createFromFile(File schemaFile) {
        return SchemaInfoImpl.createFromFileName(schemaFile.getName());
    }

    public static SchemaInfoImpl createFromFileName(String fileName) {
        String jarFileBaseName = null;
        String jarFileExtention = null;
        try {
            StringTokenizer outterTokenizer = new StringTokenizer(fileName, ".");
            jarFileBaseName = outterTokenizer.nextToken();
            jarFileExtention = outterTokenizer.nextToken();
        }
        catch (Throwable e) {
            return null;
        }
        if (!"jar".equals(jarFileExtention)) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(jarFileBaseName, "_");
            String header = tokenizer.nextToken();
            String productId = tokenizer.nextToken();
            String majVersion = tokenizer.nextToken();
            String minVersion = tokenizer.nextToken();
            String relVersion = tokenizer.nextToken();
            if (header.equals("DBS")) {
                return new SchemaInfoImpl(SchemaType.valueOf(productId), Integer.parseInt(majVersion), Integer.parseInt(minVersion), Integer.parseInt(relVersion));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static SchemaInfoImpl createFromFileNameForMigration(String fileName) {
        String jarFileBaseName = null;
        String jarFileExtention = null;
        try {
            StringTokenizer outterTokenizer = new StringTokenizer(fileName, ".");
            jarFileBaseName = outterTokenizer.nextToken();
            jarFileExtention = outterTokenizer.nextToken();
        }
        catch (Throwable e) {
            return null;
        }
        if (!"jar".equals(jarFileExtention)) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(jarFileBaseName, "_");
            String header = tokenizer.nextToken();
            String productId = tokenizer.nextToken();
            String majVersion = tokenizer.nextToken();
            String minVersion = tokenizer.nextToken();
            String relVersion = tokenizer.nextToken();
            if (header.equals("DBS")) {
                if (productId.equalsIgnoreCase("PM")) {
                    return new SchemaInfoImpl(SchemaType.PPM, Integer.parseInt(majVersion), Integer.parseInt(minVersion), Integer.parseInt(relVersion));
                }
                if (productId.equalsIgnoreCase("PPM")) {
                    return new SchemaInfoImpl(SchemaType.PM, Integer.parseInt(majVersion), Integer.parseInt(minVersion), Integer.parseInt(relVersion));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static SchemaInfoImpl create(String productAbbreviation, String versionString) {
        SchemaType type = SchemaInfoImpl.getProductTypeFromAbbreviation(productAbbreviation);
        int[] version = SchemaInfoImpl.extractVersionInfo(versionString);
        return new SchemaInfoImpl(type, version[0], version[1], version[2]);
    }

    private static SchemaType getProductTypeFromAbbreviation(String abbreviation) {
        return SchemaType.valueOf(abbreviation.toUpperCase());
    }

    private static int[] extractVersionInfo(String versionString) {
        int[] versionInfo = new int[3];
        StringTokenizer versionTokenizer = new StringTokenizer(versionString, ".");
        for (int i = 0; i < 3 && versionTokenizer.hasMoreTokens(); ++i) {
            String nextVersionComponent = versionTokenizer.nextToken();
            versionInfo[i] = Integer.parseInt(nextVersionComponent);
        }
        return versionInfo;
    }

    @Override
    public String getFileName() {
        return SchemaJarUtil.createJarFileName(this.m_product, this.m_version);
    }

    @Override
    public int getMajVersion() {
        return this.m_version.getMajor();
    }

    @Override
    public int getMinVersion() {
        return this.m_version.getMinor();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.m_product;
    }

    @Override
    public int getRelVersion() {
        return this.m_version.getRelease();
    }

    public String toString() {
        return this.m_product.toString() + "_" + this.m_version.toString();
    }

    @Override
    public final String getVersionQuery(ServerType type) throws DBMTException {
        return SchemaInfoImpl.getVersionQuery(type, this.getSchemaType());
    }

    public static String getVersionQuery(ServerType type, SchemaType schemaType) throws DBMTException {
        Map<ServerType, String> map = s_versionQueryMap.get((Object)schemaType);
        if (map == null) {
            throw new VersionQueryNotFound(type, schemaType);
        }
        String versionQuery = map.get((Object)type);
        if (versionQuery == null) {
            throw new VersionQueryNotFound(type, schemaType);
        }
        return versionQuery;
    }

    public final void setVersionQuery(String versionQuery, ServerType type) {
        Map<ServerType, String> map = s_versionQueryMap.get((Object)this.getSchemaType());
        if (map == null) {
            map = new HashMap<ServerType, String>();
            s_versionQueryMap.put(this.getSchemaType(), map);
        }
        map.put(type, versionQuery);
    }
}

