/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentProcessor;
import com.primavera.database.common.argsprocessor.CharTracker;
import com.primavera.database.common.argsprocessor.ParameterDef;

public class IntDef
extends ParameterDef {
    private final int m_min;
    private final int m_max;

    public IntDef(char chr, String name, String desc, int min, int max) {
        super(chr, name, desc);
        this.m_min = min;
        this.m_max = max;
    }

    public IntDef(char chr, String name, int min, int max) {
        this(chr, name, null, min, max);
    }

    public IntDef(char chr, String name, String desc) {
        this(chr, name, desc, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntDef(char chr, String name) {
        this(chr, name, null);
    }

    @Override
    public String getAbbreviation() {
        return "-" + this.m_char + "NN";
    }

    @Override
    protected void bindToClass(Class<?> clas) {
        super.bindToClass(clas);
        Class<?> type = this.m_field.getType();
        if (type != Integer.class && type != Integer.TYPE) {
            throw new IllegalArgumentException("Field '" + this.m_name + "'in " + clas.getName() + " is not of type int");
        }
    }

    @Override
    public void handle(ArgumentProcessor proc) {
        boolean minus = false;
        boolean digits = false;
        long value = 0L;
        CharTracker track = proc.getChars();
        if (track.hasNext()) {
            char chr = track.peek();
            if (chr == '-' || chr == '+') {
                minus = chr == '-';
                track.next();
            }
            while (track.hasNext() && (chr = track.peek()) >= '0' && chr <= '9') {
                track.next();
                digits = true;
                value = value * 10L + (long)(chr - 48);
            }
        }
        long l = value = minus ? -value : value;
        if (!digits) {
            proc.reportArgumentError(this.m_char, "Missing value");
        } else if (value < (long)this.m_min || value > (long)this.m_max) {
            proc.reportArgumentError(this.m_char, "Value out of range");
        } else {
            proc.setValue(new Integer((int)value), this.m_field);
        }
    }
}

