/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.argsprocessor;

import com.primavera.database.common.argsprocessor.ArgumentProcessor;
import com.primavera.database.common.argsprocessor.BoolDef;
import com.primavera.database.common.argsprocessor.FloatDef;
import com.primavera.database.common.argsprocessor.IntDef;
import com.primavera.database.common.argsprocessor.ParameterDef;
import com.primavera.database.common.argsprocessor.StringDef;

public class PlanGen {
    private static final ParameterDef[] PARM_DEFS = new ParameterDef[]{new BoolDef('c', "m_isConcise"), new IntDef('f', "m_initialRevenue", 10, 10000), new FloatDef('g', "m_growthRate", 1.0f, 100.0f), new StringDef('n', "m_productDescription")};
    private boolean m_isConcise;
    private final int m_initialRevenue = 1000;
    private final float m_growthRate = 1.5f;
    private final String m_productDescription = "eFood - (Really) Fast Food Online";

    public static void main(String[] args) {
        if (args.length > 0) {
            PlanGen inst = new PlanGen();
            int next = ArgumentProcessor.processArgs(args, PARM_DEFS, inst);
            if (next >= args.length) {
                System.err.println("Missing required output file name");
                System.exit(1);
            }
            System.out.println("Generating business plan for \"" + inst.m_productDescription + '\"');
            System.out.println("Arguments are concise=" + inst.m_isConcise + ", initial revenue=" + inst.m_initialRevenue + ", growth rate=" + inst.m_growthRate);
        } else {
            System.out.println("\nUsage: java PlanGen [-options] file\nOptions are:\n  c  concise plan\n  f  first year revenue (K$)\n  g  growth rate\n  n  product description");
        }
    }
}

