/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.connection;

import com.primavera.database.common.connection.DatabaseConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ConnectionUtil {
    private static final CloseErrorHandler NOOP_ERROR_HANDLER = new CloseErrorHandler(){

        @Override
        public void handle(SQLException e) {
        }
    };
    private static CloseErrorHandler s_closeHandler;

    private static CloseErrorHandler getGlobalErrorHandler() {
        if (s_closeHandler == null) {
            return NOOP_ERROR_HANDLER;
        }
        return s_closeHandler;
    }

    public static void setCloseErrorHandler(CloseErrorHandler handler) {
        s_closeHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doConnectionOperation(String connectionString, ConnectionOperation connectOp, CloseErrorHandler handler) throws Exception {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionString);
            connectOp.performConnectionOperation(connection);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    handler.handle(e);
                }
            }
        }
    }

    public static void doConnectionOperation(String connectionString, ConnectionOperation connectOp) throws Exception {
        ConnectionUtil.doConnectionOperation(connectionString, connectOp, ConnectionUtil.getGlobalErrorHandler());
    }

    public static class ConntionOperationSequence
    implements ConnectionOperation {
        private final List<ConnectionOperation> m_operations = new ArrayList<ConnectionOperation>();

        @Override
        public void performConnectionOperation(DatabaseConnection connection) throws Exception {
            for (ConnectionOperation operation : this.m_operations) {
                operation.performConnectionOperation(connection);
            }
        }
    }

    public static interface ConnectionOperation {
        public void performConnectionOperation(DatabaseConnection var1) throws Exception;
    }

    public static interface CloseErrorHandler {
        public void handle(SQLException var1) throws Exception;
    }
}

