/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.RowScrubber;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class RowContainer {
    private final String DEFAULT_NAME = "ROW_CONTAINER";
    private final Vector<RowElement> m_list = new Vector();
    private final Map<String, Integer> m_names = new HashMap<String, Integer>();
    private RowScrubber m_scrubber = null;
    private String m_name = "ROW_CONTAINER";

    public int size() {
        return this.m_list.size();
    }

    public void clear() {
        this.m_list.clear();
        this.m_names.clear();
    }

    public void clearValues() {
        for (RowElement re : this.m_list) {
            re.setEmpty();
        }
    }

    public void addElement(RowElement e) {
        if (e.getName().length() == 0) {
            e.setName("ELEMENT" + String.valueOf(this.m_list.size() + 1));
        }
        this.m_list.add(e);
        int j = 0;
        for (RowElement ce : this.m_list) {
            if (e.getName().equalsIgnoreCase(ce.getName())) {
                this.m_names.put(ce.getName(), j);
                break;
            }
            ++j;
        }
    }

    public void addElement(GenericDataTypes type, String name, String val) throws Exception {
        RowElement re = new RowElement();
        re.setName(name);
        re.setValue(val);
        this.addElement(re);
    }

    public void addElement(GenericDataTypes type, String name, int val) throws Exception {
        this.addElement(type, name, String.valueOf(val));
    }

    public void addElement(GenericDataTypes type, String name, Date val) throws Exception {
        RowElement re = new RowElement();
        re.setName(name);
        re.setDate(val);
        this.addElement(re);
    }

    public void addElement(GenericDataTypes type, String name, double val) throws Exception {
        this.addElement(type, name, String.valueOf(val));
    }

    public Iterator<RowElement> iterator() {
        return this.m_list.iterator();
    }

    public RowElement get(int i) {
        return this.m_list.get(i - 1);
    }

    public RowElement get(String name) {
        Integer i = this.m_names.get(name);
        if (i == null) {
            return null;
        }
        return this.get(i + 1);
    }

    public void setScrubber(RowScrubber rs) {
        this.m_scrubber = rs;
    }

    public RowScrubber getScrubber() {
        return this.m_scrubber;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean needsScrub(String name) {
        if (this.m_scrubber == null) {
            return false;
        }
        return this.m_scrubber.needsScrub(name);
    }

    boolean needsElementScrub(String name, String elemname) {
        if (this.m_scrubber == null) {
            return false;
        }
        return this.m_scrubber.needsElementScrub(name, elemname);
    }

    public void scrub() {
        if (this.m_scrubber == null) {
            return;
        }
        int j = 1;
        for (RowElement re : this.m_list) {
            RowElement newre;
            if (this.m_scrubber.needsElementScrub(this.m_name, re.getName()) && !(newre = this.m_scrubber.clean(re)).equals(re)) {
                this.m_list.setElementAt(newre, j);
            }
            ++j;
        }
    }

    public boolean isExcluded(String name) {
        if (this.m_scrubber == null) {
            return false;
        }
        return this.m_scrubber.isExcluded(name);
    }

    boolean forceBase64(String name, String elemname) {
        if (this.m_scrubber == null) {
            return false;
        }
        return this.m_scrubber.forceBase64(name, elemname);
    }
}

