/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.TableManipulatorAdapter;
import com.primavera.database.common.TableManipulatorInterface;
import com.primavera.database.common.container.RowDataHandler;
import com.primavera.database.common.container.XMLRowHandler;
import com.primavera.database.common.logging.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLRowGenerator {
    public static final String BASE_64_ENCODED_HEADER = "b64";
    private String xmlfile = null;
    private XMLRowHandler rowhandler = null;
    private Reader reader = null;
    private TableManipulatorInterface m_tableManipulator = new TableManipulatorAdapter();

    public void setRowhandler(XMLRowHandler rowhandler) {
        this.rowhandler = rowhandler;
    }

    public XMLRowHandler getRowhandler() {
        return this.rowhandler;
    }

    public String getXmlfile() {
        return this.xmlfile;
    }

    public void setXmlfile(String xmlfile) throws FileNotFoundException {
        this.xmlfile = xmlfile;
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlfile), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void run(String currentTable) {
        if (this.reader == null) {
            try {
                throw new Exception("Reader must be provided");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.rowhandler == null) {
            try {
                throw new Exception("Row handler must be specified");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = null;
        try {
            sp = spf.newSAXParser();
            XMLReader r = null;
            r = sp.getXMLReader();
            RowDataHandler handler = new RowDataHandler(this.m_tableManipulator, currentTable);
            r.setContentHandler(handler);
            handler.setRowhandler(this.rowhandler);
            Reader br = this.reader;
            try {
                r.parse(new InputSource(br));
            }
            catch (Exception e) {
                Log.warn(currentTable.toUpperCase() + " could not load properly. " + e.getMessage());
                throw e;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static GenericDataTypes GenericDataTypeFromFieldType(String field_type, String sub_type) {
        if (field_type.compareToIgnoreCase("r8") == 0) {
            return GenericDataTypes.NUMBER;
        }
        if (field_type.compareToIgnoreCase("SQLdateTime") == 0) {
            return GenericDataTypes.DATE;
        }
        if (field_type.compareToIgnoreCase("i4") == 0) {
            return GenericDataTypes.INTEGER;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("Text") == 0) {
            return GenericDataTypes.CLOB;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("XML") == 0) {
            return GenericDataTypes.XMLTYPE;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("Binary") == 0) {
            return GenericDataTypes.BLOB;
        }
        if (field_type.compareToIgnoreCase("bin.hex") == 0 && sub_type.compareToIgnoreCase("HBinary") == 0) {
            return GenericDataTypes.BLOB;
        }
        return GenericDataTypes.STRING;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public static boolean isLobType(GenericDataTypes type) {
        if (type == GenericDataTypes.BLOB) {
            return true;
        }
        if (type == GenericDataTypes.CLOB) {
            return true;
        }
        if (type == GenericDataTypes.MEMO) {
            return true;
        }
        if (type == GenericDataTypes.IMAGE) {
            return true;
        }
        return type == GenericDataTypes.XMLTYPE;
    }

    public void setTableManipulator(TableManipulatorInterface tableManipulator) {
        this.m_tableManipulator = tableManipulator;
    }

    public TableManipulatorInterface getTableManipulator() {
        return this.m_tableManipulator;
    }
}

