/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.primavera.database.tools.Dataloader.FileZipOutputProvider;
import com.primavera.database.tools.Dataloader.SampleDataScrubber;
import com.primavera.database.tools.Dataloader.output.ZipOutputter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleDriver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigHandler
extends DefaultHandler {
    private String suffix;
    private String sqlserver_user;
    private String sqlserver_password;
    private String oracle_user;
    private String oracle_password;
    private String sybase_user;
    private String sybase_password;
    private String zip_path;
    private Connection conn;
    private String dbtype;

    ConfigHandler() {
    }

    public void setPath(String path) {
        this.zip_path = path;
    }

    private boolean connect(String servertype, String host, String port, String dbname, String name) {
        block7: {
            String url = "";
            try {
                if ("SQLSERVER".equalsIgnoreCase(servertype)) {
                    String password;
                    String username;
                    if ("EXP".equalsIgnoreCase(this.dbtype)) {
                        username = this.sybase_user;
                        password = this.sybase_password;
                    } else {
                        username = this.sqlserver_user;
                        password = this.sqlserver_password;
                    }
                    url = "jdbc:sqlserver://" + host + ":" + port + ";database=" + dbname + this.suffix;
                    DriverManager.registerDriver((Driver)new SQLServerDriver());
                    this.conn = DriverManager.getConnection(url, username, password);
                    break block7;
                }
                if ("SYBASE".equalsIgnoreCase(servertype)) {
                    return false;
                }
                if ("ORACLE".equalsIgnoreCase(servertype)) {
                    String username = this.oracle_user;
                    String password = this.oracle_password;
                    url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + dbname;
                    DriverManager.registerDriver((Driver)new OracleDriver());
                    this.conn = DriverManager.getConnection(url, username, password);
                    break block7;
                }
                return false;
            }
            catch (SQLException ex) {
                System.out.println(" Url: " + url);
                System.out.println("ERROR: " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private void RunSampleDataPump(String servertype, String host, String port, String dbname, String name) {
        if (this.connect(servertype, host, port, dbname, name)) {
            try {
                FileZipOutputProvider outputProvider = new FileZipOutputProvider();
                ZipOutputter zipOutputter = new ZipOutputter(outputProvider);
                zipOutputter.setScrubber(new SampleDataScrubber());
                zipOutputter.setTablePattern("%");
                String zipname = name + ".zip";
                outputProvider.setZipName(zipname.toLowerCase());
                outputProvider.setZipPath(this.zip_path);
                zipOutputter.output(this.conn);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        } else {
            System.out.println("Fail to connect to " + host + ":" + port + " " + name + this.suffix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("SETTINGS".equalsIgnoreCase(qName)) {
            this.suffix = atts.getValue("SUFFIX");
            this.sqlserver_user = atts.getValue("SQLSERVER_USER");
            this.sqlserver_password = atts.getValue("SQLSERVER_PASSWORD");
            this.oracle_user = atts.getValue("ORACLE_USER");
            this.oracle_password = atts.getValue("ORACLE_PASSWORD");
            this.sybase_user = atts.getValue("SYBASE_USER");
            this.sybase_password = atts.getValue("SYBASE_PASSWORD");
        } else if ("DATA".equalsIgnoreCase(qName)) {
            this.dbtype = atts.getValue("DBTYPE");
            this.RunSampleDataPump(atts.getValue("SERVERTYPE"), atts.getValue("HOST"), atts.getValue("PORT"), atts.getValue("DBNAME"), atts.getValue("SAMPLE_NAME"));
        }
    }
}

