/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.DatabaseToolException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class DependentOrder {
    private final Connection m_conn;
    private final DatabaseConnection m_dbconn;
    private final List<String> m_source_list;
    List<String> list;
    DataDictionary dd;

    public DependentOrder(DatabaseConnection dbconn, List<String> source_list) {
        this.m_conn = dbconn.getConnection();
        this.m_dbconn = dbconn;
        this.m_source_list = source_list;
    }

    void processTable(String tablename) throws DatabaseToolException {
        ArrayList<String> deptabs;
        try {
            deptabs = this.dd.getRefTables(this.m_dbconn, tablename);
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage());
        }
        for (String reftab : deptabs) {
            if (this.list.contains(tablename)) continue;
            this.processTable(reftab);
        }
        if (this.m_source_list.contains(tablename) && !this.list.contains(tablename)) {
            this.list.add(tablename);
        }
    }

    public List<String> getOrderList() throws DatabaseToolException {
        try {
            this.dd = new DataDictionary(this.m_conn);
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage());
        }
        this.list = new ArrayList<String>();
        for (String tablename : this.m_source_list) {
            if (this.list.contains(tablename)) continue;
            this.processTable(tablename);
        }
        if (this.list.size() > this.m_source_list.size()) {
            throw new DatabaseToolException("Ordered list has different size " + String.valueOf(this.list.size()) + "(" + String.valueOf(this.m_source_list.size()) + ")");
        }
        return this.list;
    }
}

