/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.Dataloader.TableScrubber;
import java.util.ArrayList;

public class SampleDataScrubber
extends TableScrubber {
    public SampleDataScrubber() {
        this.add("PREFER", "LICENSE_DATA");
        this.add("SETTINGS", "");
        this.addForceBase64("TASKSUM", "SPREAD_DATA");
        this.addForceBase64("TRSRCSUM", "SPREAD_DATA");
        this.addExcluded("SETTINGS");
        this.addExcluded("BGPLOG");
        this.addExcluded("SPIDMAP");
        this.addExcluded("DLTACCT");
        this.addExcluded("DLTACTV");
        this.addExcluded("DLTOBS");
        this.addExcluded("DLTROLE");
        this.addExcluded("DLTRSRC");
        this.addExcluded("DLTRSRL");
        this.addExcluded("DLTUSER");
        this.addExcluded("PRMAUDIT");
        this.addExcluded("PAUDIT");
        this.addExcluded("PRMQUEUE");
        this.addExcluded("USESSAUD");
        this.addExcluded("TEMPKEYS");
        this.addExcluded("TPROJMAP");
        this.addExcluded("USESSION");
        this.addExcluded("PKXREF");
        this.addExcluded("UPKLIST");
        this.add("GCHANGE", "GCHANGE_DATA");
        this.add("FILTPROP", "FILTER_DATA");
        this.add("PFOLIO", "PFOLIO_DATA");
        this.add("RPT_DATA", "RPT");
    }

    @Override
    public RowElement clean(RowElement elem) {
        if (elem.getName().equalsIgnoreCase("LICENSE_DATA")) {
            elem.setEmpty();
        }
        if (elem.getName().equalsIgnoreCase("GCHANGE_DATA") || elem.getName().equalsIgnoreCase("FILTER_DATA") || elem.getName().equalsIgnoreCase("PFOLIO_DATA") || elem.getName().equalsIgnoreCase("RPT_DATA")) {
            String s = elem.getValue().replaceAll("\r\n", "");
            try {
                elem.setValue(s);
            }
            catch (Exception e) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.error.sampledatascrubber", new String[]{e.getLocalizedMessage()}));
            }
        }
        return elem;
    }

    @Override
    public boolean keepRow(RowContainer rc) {
        RowElement re;
        if (rc.getName().equalsIgnoreCase("SETTINGS") && (re = rc.get("SETTING_NAME")) != null) {
            ArrayList<String> excluded_settings = new ArrayList<String>();
            excluded_settings.add("JOBID");
            excluded_settings.add("HEARTBEATTIME");
            if (rc.get("NAMESPACE").getValue().startsWith("database.audit") || excluded_settings.contains(rc.get("SETTING_NAME").getValue())) {
                return false;
            }
        }
        return true;
    }
}

