/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RetrieveExpCustomfieldInfoFromSampleDataZip {
    private final String m_sampleDataSource;
    private final ZipStreamOpenner m_zipStreamOpener;
    public final RetrieveExpCustomFieldInfo<CSDFRecord> m_csdfRecordRetriever = new RetrieveExpCustomFieldInfo<CSDFRecord>(){

        @Override
        public Collection<CSDFRecord> getRecords() throws Exception {
            return RetrieveExpCustomfieldInfoFromSampleDataZip.this.getCSDFRecords();
        }
    };
    public final RetrieveExpCustomFieldInfo<GCDFRecord> m_gcdfRecordRetriever = new RetrieveExpCustomFieldInfo<GCDFRecord>(){

        @Override
        public Collection<GCDFRecord> getRecords() throws Exception {
            return RetrieveExpCustomfieldInfoFromSampleDataZip.this.getGCDFRecords();
        }
    };

    public RetrieveExpCustomfieldInfoFromSampleDataZip(String connectString, SchemaInfo info) {
        this.m_zipStreamOpener = new ResourceZipStreamOpener();
        this.m_sampleDataSource = RetrieveExpCustomfieldInfoFromSampleDataZip.createSampleDataSourceFromConnectStringAndSchemaInfo(connectString, info);
    }

    public RetrieveExpCustomfieldInfoFromSampleDataZip(String pathToSampleDataFile) {
        this.m_zipStreamOpener = new FileZipStreamOpener();
        this.m_sampleDataSource = pathToSampleDataFile;
    }

    private static String createSampleDataSourceFromConnectStringAndSchemaInfo(String connectString, SchemaInfo info) {
        ConnectStringParse parsedConnectString = new ConnectStringParse(connectString);
        return "sampledata/" + info + "/" + parsedConnectString.getSampleString();
    }

    private Document getTableDocument(String tableName) throws ParserConfigurationException, SAXException {
        DBMTLogger.info(Channel.DEV, "The Sample Data URL is " + this.m_sampleDataSource);
        InputStream zipInStream = this.m_zipStreamOpener.getZipInputStreamFromDataSource(this.m_sampleDataSource);
        if (zipInStream == null) {
            DBMTLogger.info(Channel.DEV, "No Resource Found At " + this.m_sampleDataSource);
        }
        ZipInputStream zipStream = new ZipInputStream(zipInStream);
        try {
            ZipEntry zipEntry = zipStream.getNextEntry();
            String xmlFileName = tableName + ".xml";
            while (zipEntry != null) {
                if (xmlFileName.equalsIgnoreCase(zipEntry.getName())) {
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                    return docBuilder.parse(new InputSource(zipStream));
                }
                zipEntry = zipStream.getNextEntry();
            }
        }
        catch (IOException e) {
            DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.error.customcolumns.sample.ioexception", new String[]{tableName, e.getLocalizedMessage(), e.getMessage()}), e);
            System.out.println(e);
            e.printStackTrace();
        }
        DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.error.customcolumns.sample.tablenotfound", new String[]{tableName}));
        return null;
    }

    public Collection<CSDFRecord> getCSDFRecords() throws ParserConfigurationException, SAXException {
        ArrayList<CSDFRecord> recordList = new ArrayList<CSDFRecord>();
        Document csdfDoc = this.getTableDocument("csdf");
        this.retrieveCSDFRecords(recordList, csdfDoc);
        return recordList;
    }

    private void retrieveCSDFRecords(List<CSDFRecord> recordList, Document csdfDoc) {
        NodeList rows = csdfDoc.getElementsByTagName("ROW");
        for (int i = 0; i < rows.getLength(); ++i) {
            recordList.add(this.getCSDFRecordFromFields(rows.item(i)));
        }
    }

    private void retrieveGCDFRecords(List<GCDFRecord> recordList, Document csdfDoc) {
        NodeList rows = csdfDoc.getElementsByTagName("ROW");
        for (int i = 0; i < rows.getLength(); ++i) {
            if (!rows.item(i).getAttributes().getNamedItem("cdi_view").getNodeName().equals("CNMT")) continue;
            recordList.add(this.getGCDFRecordFromFields(rows.item(i)));
        }
    }

    private CSDFRecord getCSDFRecordFromFields(Node node) {
        CSDFRecord record = new CSDFRecord();
        int colNum = Integer.parseInt(node.getAttributes().getNamedItem("colno").getNodeValue());
        int startCol = Integer.parseInt(node.getAttributes().getNamedItem("start_column").getNodeValue());
        int width = Integer.parseInt(node.getAttributes().getNamedItem("width").getNodeValue());
        record.setColumnNumber(colNum);
        record.setDefinitionName(node.getAttributes().getNamedItem("definition_name").getNodeValue());
        record.setDescription(node.getAttributes().getNamedItem("description").getNodeValue());
        record.setMasterKey(node.getAttributes().getNamedItem("master_key").getNodeValue());
        record.setStartColumn(startCol);
        record.setWidth(width);
        return record;
    }

    private GCDFRecord getGCDFRecordFromFields(Node node) {
        GCDFRecord record = new GCDFRecord();
        int cdiLength = Integer.parseInt(node.getAttributes().getNamedItem("cdi_length").getNodeValue());
        record.setCdiLength(cdiLength);
        record.setCdiName(node.getAttributes().getNamedItem("cdi_name").getNodeValue());
        record.setCdiTable(node.getAttributes().getNamedItem("cdi_table").getNodeValue());
        record.setCdiType(node.getAttributes().getNamedItem("cdi_type").getNodeValue());
        record.setDescription(node.getAttributes().getNamedItem("description").getNodeValue());
        return record;
    }

    public Collection<GCDFRecord> getGCDFRecords() throws Exception {
        ArrayList<GCDFRecord> recordList = new ArrayList<GCDFRecord>();
        Document gcdfDoc = this.getTableDocument("gcdf");
        this.retrieveGCDFRecords(recordList, gcdfDoc);
        return recordList;
    }

    public static class FileZipStreamOpener
    implements ZipStreamOpenner {
        @Override
        public InputStream getZipInputStreamFromDataSource(String sampleDataSource) {
            try {
                return new FileInputStream(new File(sampleDataSource));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class ResourceZipStreamOpener
    implements ZipStreamOpenner {
        @Override
        public InputStream getZipInputStreamFromDataSource(String sampleDataSource) {
            return ClassLoader.getSystemClassLoader().getResourceAsStream(sampleDataSource);
        }
    }

    public static interface ZipStreamOpenner {
        public InputStream getZipInputStreamFromDataSource(String var1);
    }
}

