/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.SchemaValidation;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaJarUtil;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.connection.DatabaseMetaData;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.SchemaValidation.SchemaBuilder;
import com.primavera.database.tools.SchemaValidation.SchemaBuilderListener;
import com.primavera.database.tools.dbmt.DBMTException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class SchemaValidation {
    public static final String COMPARE_TEMP_FILE = System.getProperty("java.io.tmpdir") + File.separatorChar + "prm_sv_compare.xml";
    public static final String RESULT_TEMP_FILE = System.getProperty("java.io.tmpdir") + File.separatorChar + "prm_sv_result.xml";
    public static final String SCRUB_TEMP_FILE = System.getProperty("java.io.tmpdir") + File.separatorChar + "prm_sv_scrubbed_result.xml";
    public static final String REPORT_FILE = System.getProperty("user.home") + File.separatorChar + "PRM-Validate.html";
    static final String EXISTING_BGJOBUSER_QUERY = "select a.owner owner from all_synonyms a, all_synonyms b where a.table_owner = b.table_owner and a.table_name = b.table_name and b.table_name='DATA_MONITOR' and b.owner = ? and a.owner != ?";
    private DatabaseConnection m_conn;
    private Document sourceSchemaDoc;
    private Document targetSchemaDoc;
    private URL sourceURL;
    private URL targetURL;
    private SchemaBuilderListener buildListener = null;
    private String privilegedUser = "PRIVUSER";
    private String publicUser = "PUBLIC";
    private String pxrptUser = "PXRPTUSER";
    private String bgjobUser = "BGJOBUSER";
    private String processType = "schemaval";
    private ProductSuiteType suite = ProductSuiteType.PM;
    private DOMResult compareResultXML;

    public DatabaseConnection getConnection() {
        return this.m_conn;
    }

    public void setConnection(DatabaseConnection m_conn) {
        this.m_conn = m_conn;
    }

    public void run(SchemaInfoRetriever schemainfor) throws DatabaseToolException, DBMTException {
        try {
            if (this.m_conn == null || this.m_conn.getConnection().isClosed()) {
                throw new DatabaseToolException("No Database Connection");
            }
            SchemaInfo schema = schemainfor.loadSchemaInfo(this.m_conn);
            String process = "install";
            String schemaFile = SchemaJarUtil.getResource(schema, process, SchemaJarUtil.getSchemaSpecFilename(schema));
            DBMTLogger.info(Channel.DEV, "Schema file: " + schemaFile);
            this.setTargetURL(ClassLoader.getSystemClassLoader().getResource(schemaFile));
            DBMTLogger.info(Channel.DEV, "Running Schema Compare");
            this.transformSchemaCompare(process);
            DBMTLogger.info(Channel.DEV, "Running Schema Scrub");
            this.transformSchemaScrub();
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public void runForMigration(SchemaInfoRetriever schemainfor) throws DatabaseToolException, DBMTException {
        try {
            if (this.m_conn == null || this.m_conn.getConnection().isClosed()) {
                throw new DatabaseToolException("No Database Connection");
            }
            SchemaInfo schema = schemainfor.loadSchemaInfoForMigration(this.m_conn);
            String process = "migrate";
            String schemaFile = SchemaJarUtil.getResourceForMigration(schema, process, SchemaJarUtil.getSchemaSpecFilename(schema), "changeDir");
            DBMTLogger.info(Channel.DEV, "Schema file: " + schemaFile);
            this.setTargetURL(ClassLoader.getSystemClassLoader().getResource(schemaFile));
            DBMTLogger.info(Channel.DEV, "Running Schema Compare");
            this.transformSchemaCompare(process);
            DBMTLogger.info(Channel.DEV, "Running Schema Scrub");
            this.transformSchemaScrub();
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public DOMResult getHTMLReport() throws DatabaseToolException {
        if (this.compareResultXML == null) {
            return null;
        }
        URL xsltURL = this.getClass().getClassLoader().getResource("schema_validation_output.xsl");
        Properties xslprops = new Properties();
        Document resultsXML = (Document)this.compareResultXML.getNode();
        try {
            return this.transformDOM(new StreamSource(xsltURL.openStream()), resultsXML, xslprops);
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public void buildSchemaDocument() throws DatabaseToolException, SQLException {
        DatabaseMetaData meta = new DatabaseMetaData();
        meta.setDatabaseConnection(this.m_conn);
        SchemaBuilder sb = new SchemaBuilder(meta);
        if (this.buildListener != null) {
            sb.addListener(this.buildListener);
        }
        sb.setSchemaString(DatabaseHelper.getSchemaVersionString(this.m_conn.getConnection()));
        sb.generate();
        this.sourceSchemaDoc = sb.getDocument();
    }

    public void saveCompareFile() throws DatabaseToolException {
        if (this.sourceSchemaDoc == null) {
            throw new DatabaseToolException("No schema document generated");
        }
        File srcfile = new File(COMPARE_TEMP_FILE);
        this.docToFile(this.sourceSchemaDoc, srcfile);
        try {
            this.sourceURL = srcfile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    private Document docFromFile(File f) throws DatabaseToolException {
        Document doc = null;
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            doc = docbuilder.parse(f);
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        return doc;
    }

    private Document docFromURL(URL url) throws DatabaseToolException {
        Document doc = null;
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            doc = docbuilder.parse(url.openStream());
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        return doc;
    }

    private DOMResult transformDOM(Source xslt, Document doc, Properties params) throws DatabaseToolException {
        DOMResult result = new DOMResult();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslt);
            Enumeration<?> parameters = params.propertyNames();
            while (parameters.hasMoreElements()) {
                String name = (String)parameters.nextElement();
                transformer.setParameter(name, params.get(name));
            }
            transformer.transform(new DOMSource(doc), result);
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        return result;
    }

    private void transformSchemaScrub() throws DatabaseToolException {
        File resultFile = new File(RESULT_TEMP_FILE);
        if (!resultFile.exists()) {
            throw new DatabaseToolException("Missig result file " + RESULT_TEMP_FILE);
        }
        Document resultDoc = this.docFromFile(resultFile);
        Object o = new Object();
        URL xsltURL = this.getClass().getClassLoader().getResource("schema_validation_scrub.xsl");
        Properties xslprops = new Properties();
        xslprops.put("sprefix", this.getConnection().getServerType().getShortName().toUpperCase());
        try {
            this.compareResultXML = this.transformDOM(new StreamSource(xsltURL.openStream()), resultDoc, xslprops);
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        this.docToFile((Document)this.compareResultXML.getNode(), new File(SCRUB_TEMP_FILE));
    }

    private void transformSchemaCompare(String process) throws DatabaseToolException {
        Object o = new Object();
        URL xsltURL = this.getClass().getClassLoader().getResource("schema_compare.xsl");
        Properties xslprops = new Properties();
        DBMTLogger.info(Channel.DEV, "Source URL: " + this.sourceURL.getPath());
        xslprops.put("comparefile", this.sourceURL);
        DBMTLogger.info(Channel.DEV, "Target URL: " + this.targetURL.getPath());
        xslprops.put("target_schema", this.targetURL);
        DBMTLogger.info(Channel.DEV, "Privileged User: " + this.privilegedUser);
        xslprops.put("privuser", this.privilegedUser);
        DBMTLogger.info(Channel.DEV, "Public User: " + this.publicUser);
        xslprops.put("pubuser", this.publicUser);
        if (this.m_conn.getServerType() == ServerType.ORACLE) {
            this.bgjobUser = this.getBGJobUser(this.m_conn);
            DBMTLogger.info(Channel.DEV, "BG Job User: " + this.bgjobUser);
            xslprops.put("bgjobuser", this.bgjobUser);
        }
        DBMTLogger.info(Channel.DEV, "DB Type: " + this.m_conn.getServerType().getShortName());
        xslprops.put("targetdb", this.m_conn.getServerType().getShortName());
        xslprops.put("process_type", this.processType);
        if (this.suite == ProductSuiteType.PM || this.suite == ProductSuiteType.PPM && process.equals("migrate")) {
            DBMTLogger.info(Channel.DEV, "PX Reporting User: " + this.pxrptUser);
            xslprops.put("pxrptuser", this.pxrptUser);
        }
        try {
            DOMResult result = this.transformDOM(new StreamSource(xsltURL.openStream()), this.targetSchemaDoc, xslprops);
            this.docToFile((Document)result.getNode(), new File(RESULT_TEMP_FILE));
        }
        catch (IOException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public void docToFile(Document doc, File f) throws DatabaseToolException {
        DOMSource source = new DOMSource(doc);
        this.docToFile(source, f);
    }

    public void docToFile(DOMSource domsource, File f) throws DatabaseToolException {
        try {
            FileOutputStream out = new FileOutputStream(f);
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domsource, result);
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public Document getSourceSchemaDoc() {
        return this.sourceSchemaDoc;
    }

    public Document getTargetSchemaDoc() {
        return this.targetSchemaDoc;
    }

    private void setTargetSchemaDoc(Document targetSchemaDoc) {
        this.targetSchemaDoc = targetSchemaDoc;
    }

    private void setSourceSchemaDoc(Document sourceSchemaDoc) {
        this.sourceSchemaDoc = sourceSchemaDoc;
    }

    public ProductSuiteType getSuite() {
        return this.suite;
    }

    public void setSuite(ProductSuiteType suite) {
        this.suite = suite;
    }

    public URL getTargetURL() {
        return this.targetURL;
    }

    public void setTargetURL(URL targetURL) throws DatabaseToolException {
        this.setTargetSchemaDoc(this.docFromURL(targetURL));
        this.targetURL = targetURL;
    }

    public URL getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(URL sourceURL) throws DatabaseToolException {
        this.setSourceSchemaDoc(this.docFromURL(sourceURL));
        this.sourceURL = sourceURL;
    }

    public SchemaBuilderListener getBuildListener() {
        return this.buildListener;
    }

    public void setBuildListener(SchemaBuilderListener buildListener) {
        this.buildListener = buildListener;
    }

    public String getPrivilegedUser() {
        return this.privilegedUser;
    }

    public void setPrivilegedUser(String privilegedUser) {
        this.privilegedUser = privilegedUser;
    }

    public String getPxrptUser() {
        return this.pxrptUser;
    }

    public void setPxrptUser(String pxrptUser) {
        this.pxrptUser = pxrptUser;
    }

    public String getPublicUser() {
        return this.publicUser;
    }

    public void setPublicUser(String publicUser) {
        this.publicUser = publicUser;
    }

    public String getBGJobUser(DatabaseConnection dbconn) {
        String username = "BGJOBUSER";
        try {
            PreparedStatement stmt = dbconn.getConnection().prepareStatement(EXISTING_BGJOBUSER_QUERY);
            stmt.setString(1, this.getPrivilegedUser().toUpperCase());
            stmt.setString(2, this.getPrivilegedUser().toUpperCase());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                username = rs.getString("owner");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return username;
    }

    public static interface SchemaInfoRetriever {
        public SchemaInfo loadSchemaInfo(DatabaseConnection var1) throws DBMTException;

        public SchemaInfo loadSchemaInfoForMigration(DatabaseConnection var1) throws DBMTException;
    }
}

