/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.EmptyStackException;
import java.util.Random;
import java.util.Stack;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.pki.BadPaddingException;
import oracle.security.pki.Cipher;
import oracle.security.pki.CipherSpi;
import oracle.security.pki.DESSecretKey;
import oracle.security.pki.IllegalBlockSizeException;
import oracle.security.pki.IvParameterSpec;
import oracle.security.pki.PBEParameterSpec;
import oracle.security.pki.ShortBufferException;

class PBEwMD5aDES
extends CipherSpi {
    private Cipher b;
    private MessageDigest c = null;
    private AlgorithmParameters d;
    private static int e = 8;
    static Stack a = new Stack();

    PBEwMD5aDES() {
    }

    protected void a(String string) {
    }

    protected void b(String string) {
    }

    protected int b() {
        return this.b.getBlockSize();
    }

    protected int a(int n) {
        return this.b.getOutputSize(n);
    }

    protected byte[] c() {
        return this.b.getIV();
    }

    protected AlgorithmParameters d() {
        return this.b.getParameters();
    }

    protected void a(int n, Key key, Random random) throws InvalidKeyException {
        throw new InvalidKeyException("AlgorithmParameter is required.");
    }

    protected void a(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || !(key instanceof DESSecretKey)) {
            throw new InvalidKeyException("Missing password");
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter is not PBEParameterSpec");
        }
        try {
            byte[] byArray;
            try {
                if (!a.empty()) {
                    this.c = (MessageDigest)a.pop();
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            if (this.c == null) {
                this.c = JCEUtil.getMessageDigestInstance("MD5");
            } else {
                this.c.reset();
            }
            this.b = Cipher.getInstance("DES/CBC/PKCS5Padding");
            if (algorithmParameterSpec == null) {
                if (random == null) {
                    random = new Random();
                }
                byArray = new byte[this.b.getBlockSize()];
                random.nextBytes(byArray);
                algorithmParameterSpec = new PBEParameterSpec(byArray, 12);
            }
            if (this.d == null) {
                this.d = AlgorithmParameters.getInstance("PBE");
                this.d.init(algorithmParameterSpec);
            }
            byArray = this.a(key, (PBEParameterSpec)algorithmParameterSpec);
            IvParameterSpec ivParameterSpec = this.b(byArray);
            DESSecretKey dESSecretKey = this.a(byArray);
            this.b.init(n, (Key)dESSecretKey, ivParameterSpec, random);
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("cannot initialize PBE");
        }
    }

    protected void a(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null && !algorithmParameters.getAlgorithm().equals("PBE")) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        try {
            this.d = algorithmParameters;
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (algorithmParameters != null) {
                Class<?> clazz = Class.forName("javax.crypto.spec.PBEParameterSpec");
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(clazz);
            }
            this.a(n, key, algorithmParameterSpec, random);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("PBEParameterSpec is not found");
        }
    }

    protected byte[] a(byte[] byArray, int n, int n2) {
        return this.b.update(byArray, n, n2);
    }

    protected int a(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.b.update(byArray, n, n2, byArray2, n3);
    }

    protected byte[] b(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.b.doFinal(byArray, n, n2);
    }

    protected int b(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.b.doFinal(byArray, n, n2, byArray2, n3);
    }

    private byte[] a(Key key, PBEParameterSpec pBEParameterSpec) {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = pBEParameterSpec.getSalt();
        int n = pBEParameterSpec.getIterationCount();
        int n2 = this.c.getDigestLength();
        n2 = n2 > byArray.length + byArray2.length ? n2 : byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this.c.reset();
        for (int i = 0; i < n; ++i) {
            byArray3 = this.c.digest(byArray3);
        }
        a.push(this.c);
        return byArray3;
    }

    private DESSecretKey a(byte[] byArray) {
        byte[] byArray2 = new byte[e];
        System.arraycopy(byArray, 0, byArray2, 0, e);
        return new DESSecretKey(byArray2);
    }

    private IvParameterSpec b(byte[] byArray) {
        return new IvParameterSpec(byArray, byArray.length - e, e);
    }
}

