/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.formulaparser;

import com.primavera.common.formulaparser.GetVarValueException;
import com.primavera.common.formulaparser.IDataProvider;
import com.primavera.common.formulaparser.ParseException;
import com.primavera.common.formulaparser.SimpleNode;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BigNode {
    SimpleNode byte = null;
    String char = "";
    String else = "";
    String a = "";
    boolean try = true;
    int goto;
    int new;
    int if;
    int for;
    BigNode int = null;
    BigNode do = null;
    BigNode case = null;

    public BigNode() {
    }

    public BigNode(SimpleNode simpleNode) {
        this.reset();
        this.byte = simpleNode;
    }

    public BigNode(BigNode bigNode) {
        SimpleNode simpleNode = bigNode.getSimpleNode();
        this.byte = simpleNode == null ? null : new SimpleNode(simpleNode);
        this.char = bigNode.getOriginalStr();
        this.else = bigNode.getTranslatedStr();
        this.try = bigNode.getFlag();
        this.goto = bigNode.getBeginColumn();
        this.new = bigNode.getBeginLine();
        this.if = bigNode.getEndColumn();
        this.for = bigNode.getEndLine();
        this.int = bigNode.getLchild();
        this.do = bigNode.getRchild();
        this.case = bigNode.getParent();
        this.a = bigNode.getOperator();
    }

    public final void reset() {
        this.byte = null;
        this.char = "";
        this.else = "";
        this.try = true;
        this.goto = 0;
        this.new = 0;
        this.if = 0;
        this.for = 0;
        this.int = null;
        this.do = null;
        this.case = null;
        this.a = "";
    }

    public void setFlag(boolean bl) {
        this.try = bl;
    }

    public boolean getFlag() {
        return this.try;
    }

    public BigNode getParent() {
        return this.case;
    }

    public BigNode getLchild() {
        return this.int;
    }

    public BigNode getRchild() {
        return this.do;
    }

    public void setBeginColumn(int n2) {
        this.goto = n2;
    }

    public void setBeginLine(int n2) {
        this.new = n2;
    }

    public void setEndColumn(int n2) {
        this.if = n2;
    }

    public void setEndLine(int n2) {
        this.for = n2;
    }

    public int getBeginColumn() {
        return this.goto;
    }

    public int getBeginLine() {
        return this.new;
    }

    public int getEndColumn() {
        return this.if;
    }

    public int getEndLine() {
        return this.for;
    }

    public void setOriginalStr(String string) {
        this.char = string;
    }

    public String getOriginalStr() {
        return this.char;
    }

    public void setTranslatedStr(String string) {
        this.else = string;
    }

    public String getTranslatedStr() {
        return this.else;
    }

    public void setSimpleNode(SimpleNode simpleNode) {
        this.byte = simpleNode;
    }

    public SimpleNode getSimpleNode() {
        return this.byte;
    }

    public void setChildren(String string, BigNode bigNode, BigNode bigNode2) {
        this.int = bigNode;
        this.do = bigNode2;
        this.a = string;
        if (bigNode != null && bigNode2 != null) {
            this.goto = bigNode.getBeginColumn();
            this.new = bigNode.getBeginLine();
            this.if = bigNode2.getEndColumn();
            this.for = bigNode2.getEndLine();
            this.char = bigNode.getOriginalStr() + string;
            this.else = bigNode.getTranslatedStr() + string;
            bigNode.setParent(this);
            this.char = this.char + bigNode2.getOriginalStr();
            this.else = this.else + bigNode2.getTranslatedStr();
            bigNode2.setParent(this);
        } else if (bigNode != null && bigNode2 == null) {
            this.if = bigNode.getEndColumn();
            this.for = bigNode.getEndLine();
            if ("~".equals(string)) {
                string = "-";
            }
            this.char = string + bigNode.getOriginalStr();
            this.else = string + bigNode.getTranslatedStr();
            bigNode.setParent(this);
        }
    }

    public void setParent(BigNode bigNode) {
        this.case = bigNode;
    }

    public String toString() {
        return this.toDisplayAll();
    }

    public String toDisplayAll() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.byte != null) {
            stringBuilder.append(this.byte.toString());
        }
        stringBuilder.append("\nOriginal String: ").append(this.char);
        stringBuilder.append("\nTranslated String: ").append(this.else);
        stringBuilder.append("\nValid Expression: ").append(this.try);
        stringBuilder.append("\nStarting at line: ").append(this.new).append(" column: ").append(this.goto);
        stringBuilder.append("\nEnding at line: ").append(this.for).append(" column: ").append(this.if);
        return stringBuilder.toString();
    }

    public String getOperator() {
        return this.a;
    }

    public void setOperator(String string) {
        this.a = string;
    }

    public void reEvaluate(IDataProvider iDataProvider) throws ParseException {
        if ("".equals(this.a)) {
            int n2 = this.char.indexOf(91);
            if (n2 != -1) {
                int n3 = this.char.indexOf(93);
                String string = this.char.substring(n2 + 1, n3).trim();
                n2 = this.else.indexOf(91);
                n3 = this.else.indexOf(93);
                String string2 = this.else.substring(n2 + 1, n3).trim();
                try {
                    Object object = iDataProvider.getObjectValue(string2);
                    if (object == null) {
                        throw new ParseException("Uninitialized Variable: " + string + " at line: " + this.new + " column: " + this.goto);
                    }
                    this.byte.setValueObject(object);
                }
                catch (Exception exception) {
                    throw new GetVarValueException("Uninitialized Variable: " + string + " at line: " + this.new + " column: " + this.goto, exception);
                }
            }
            return;
        }
        this.int.reEvaluate(iDataProvider);
        if ("~".equals(this.a)) {
            SimpleNode simpleNode = this.int.getSimpleNode();
            double d2 = ((Number)simpleNode.getValueObject()).doubleValue();
            this.byte.setValueObject(-d2);
            return;
        }
        this.do.reEvaluate(iDataProvider);
        if ("+".equals(this.a)) {
            this.case();
        } else if ("-".equals(this.a)) {
            this.int();
        } else if ("*".equals(this.a)) {
            this.try();
        } else if ("/".equals(this.a)) {
            this.do();
        } else if (">".equals(this.a)) {
            this.byte();
        } else if ("<".equals(this.a)) {
            this.if();
        } else if (">=".equals(this.a)) {
            this.char();
        } else if ("<=".equals(this.a)) {
            this.else();
        } else if ("=".equals(this.a)) {
            this.new();
        } else if ("!=".equals(this.a)) {
            this.a();
        } else if ("IF-THEN-ELSE".equals(this.a)) {
            this.for();
        }
    }

    private void case() {
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        int n2 = this.byte.getType();
        if (n2 == 4005) {
            double d2 = ((Number)simpleNode.getValueObject()).doubleValue() + ((Number)simpleNode2.getValueObject()).doubleValue();
            this.byte.setValueObject(d2);
        } else if (n2 == 4001) {
            SimpleNode simpleNode3 = null;
            SimpleNode simpleNode4 = null;
            if (simpleNode.getType() == 4001 && (simpleNode2.getType() == 12 || simpleNode2.getType() == 4003 || simpleNode2.getType() == 4005)) {
                simpleNode3 = simpleNode;
                simpleNode4 = simpleNode2;
            } else {
                simpleNode3 = simpleNode2;
                simpleNode4 = simpleNode;
            }
            Date date = (Date)simpleNode3.getValueObject();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
            double d3 = ((Number)simpleNode4.getValueObject()).doubleValue();
            gregorianCalendar.add(12, (int)(d3 * 60.0));
            date = gregorianCalendar.getTime();
            this.byte.setValueObject(date);
        }
    }

    private void int() throws ParseException {
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        int n2 = this.byte.getType();
        if (n2 == 4005) {
            double d2 = ((Number)simpleNode.getValueObject()).doubleValue() - ((Number)simpleNode2.getValueObject()).doubleValue();
            this.byte.setValueObject(d2);
        } else if (n2 == 4001) {
            if (simpleNode.getType() == 4001 && (simpleNode2.getType() == 12 || simpleNode2.getType() == 4003 || simpleNode2.getType() == 4005)) {
                Date date = (Date)simpleNode.getValueObject();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                double d3 = ((Number)simpleNode2.getValueObject()).doubleValue();
                gregorianCalendar.add(12, (int)(-d3 * 60.0));
                date = gregorianCalendar.getTime();
                this.byte.setValueObject(date);
            } else {
                throw new ParseException();
            }
        }
    }

    private void try() throws ParseException {
        if (this.byte.getType() != 4005) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        double d2 = ((Number)simpleNode.getValueObject()).doubleValue() * ((Number)simpleNode2.getValueObject()).doubleValue();
        this.byte.setValueObject(d2);
    }

    private void do() throws ParseException {
        double d2;
        if (this.byte.getType() == 4005) {
            SimpleNode simpleNode = this.do.getSimpleNode();
            d2 = ((Number)simpleNode.getValueObject()).doubleValue();
            if (d2 == 0.0) {
                this.setFlag(false);
                throw new ParseException("Div by 0 at line: " + this.do.getBeginLine() + " column: " + this.do.getBeginColumn());
            }
        } else {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        d2 = ((Number)simpleNode.getValueObject()).doubleValue() / d2;
        this.byte.setValueObject(d2);
    }

    private void byte() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() > ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void if() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() < ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void char() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() >= ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void else() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() <= ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void new() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() == ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void a() throws ParseException {
        if (this.byte.getType() != 4009) {
            throw new ParseException();
        }
        SimpleNode simpleNode = this.int.getSimpleNode();
        SimpleNode simpleNode2 = this.do.getSimpleNode();
        this.byte.setValueObject(((Number)simpleNode.getValueObject()).doubleValue() != ((Number)simpleNode2.getValueObject()).doubleValue());
    }

    private void for() throws ParseException {
        if (this.case.getSimpleNode().getType() == 4009) {
            boolean bl = (Boolean)this.case.getSimpleNode().getValueObject();
            if (bl) {
                this.byte.setValueObject(this.int.getSimpleNode().getValueObject());
            } else {
                this.byte.setValueObject(this.do.getSimpleNode().getValueObject());
            }
        } else {
            throw new ParseException();
        }
    }
}

