/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.util;

import com.primavera.common.bo.DBType;
import com.primavera.common.util.ParamBinder;
import com.primavera.common.value.MultipartObjectIdException;
import com.primavera.common.value.ObjectId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SQLStatementUtil {
    public static final int MAX_IN_CLAUSE_SIZE = 500;
    public static final String ESCAPE_CLAUSE = " {escape '\\'} ";
    private static final int do = 20;
    private static final String if = "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?";
    private static boolean a = Boolean.getBoolean("p6.sql.disableidsequenceoptimization");

    public static String getORClause(String string, Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        return SQLStatementUtil.getORClause(string, collection.toArray(new Object[collection.size()]), 4);
    }

    public static String getORClause(String string, Object[] objectArray) {
        return SQLStatementUtil.getORClause(string, objectArray, 4);
    }

    public static String getORClause(String string, int n2, Object ... objectArray) {
        return SQLStatementUtil.getORClause(string, objectArray, n2);
    }

    public static String getORClause(String string, Object[] objectArray, int n2) {
        if (string == null || string.length() == 0 || objectArray == null || objectArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray.length > 500) {
            stringBuilder.append('(');
        }
        if (objectArray.length == 1 && !string.trim().toLowerCase().endsWith("not")) {
            stringBuilder.append('(');
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (n2 == 12) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(objectArray[0]);
            if (n2 == 12) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        for (int i2 = 0; i2 < objectArray.length; i2 += 500) {
            boolean bl = false;
            int n3 = Math.min(i2 + 500, objectArray.length);
            stringBuilder.append('(');
            stringBuilder.append(string);
            stringBuilder.append(" in (");
            if (objectArray[i2] != null) {
                if (n2 == 12) {
                    stringBuilder.append('\'');
                }
                stringBuilder.append(objectArray[i2].toString());
                if (n2 == 12) {
                    stringBuilder.append('\'');
                }
                bl = true;
            }
            for (int i3 = i2 + 1; i3 < n3; ++i3) {
                if (objectArray[i3] == null) continue;
                if (bl) {
                    stringBuilder.append(", ");
                }
                if (n2 == 12) {
                    stringBuilder.append('\'');
                }
                stringBuilder.append(objectArray[i3].toString());
                if (n2 == 12) {
                    stringBuilder.append('\'');
                }
                bl = true;
            }
            stringBuilder.append("))");
            if (n3 >= objectArray.length) continue;
            stringBuilder.append(" or ");
        }
        if (objectArray.length > 500) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String getKeyORClause(String string, Collection<? extends Object> collection) {
        if (collection.size() == 1 && !string.trim().toLowerCase().endsWith("not")) {
            return "(" + string + " = " + collection.iterator().next().toString() + ")";
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (Object object : collection) {
            arrayList.add(Integer.valueOf(object instanceof String ? (String)object : object.toString()));
        }
        return SQLStatementUtil.getKeyORClause(string, arrayList.toArray(new Integer[arrayList.size()]));
    }

    public static String getKeyORClause(String string, Collection<? extends Object> collection, ParamBinder paramBinder) {
        if (collection.size() == 0) {
            return "";
        }
        if (collection.size() == 1 && !string.trim().toLowerCase().endsWith("not")) {
            paramBinder.addBindParam(4, collection.iterator().next());
            return "(" + string + " = ?)";
        }
        if (collection.size() <= 20) {
            String string2 = "(" + string + " in (" + if.substring(0, collection.size() * 2 - 1) + "))";
            for (Object object : collection) {
                int n2 = object instanceof Integer ? 4 : (object instanceof String ? 12 : 1111);
                paramBinder.addBindParam(n2, object);
            }
            return string2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (Object object : collection) {
            arrayList.add(Integer.valueOf(object instanceof String ? (String)object : object.toString()));
        }
        return SQLStatementUtil.getKeyORClause(string, arrayList.toArray(new Integer[arrayList.size()]));
    }

    public static String getKeyORClause(String string, String ... stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            arrayList.add(Integer.valueOf(string2));
        }
        return SQLStatementUtil.getKeyORClause(string, arrayList.toArray(new Integer[arrayList.size()]));
    }

    public static String getKeyORClause(String string, ObjectId ... objectIdArray) throws MultipartObjectIdException {
        if (objectIdArray[0].isMultiPartKey()) {
            throw new MultipartObjectIdException("Multipart ObjectIds are not supported");
        }
        if (objectIdArray.length == 1) {
            return "(" + string + " = " + objectIdArray[0].getPrimaryKeyValue() + ")";
        }
        Integer[] integerArray = new Integer[objectIdArray.length];
        for (int i2 = 0; i2 < objectIdArray.length; ++i2) {
            integerArray[i2] = objectIdArray[i2].getPrimaryKeyObject();
        }
        return SQLStatementUtil.getKeyORClause(string, integerArray);
    }

    public static String getKeyORClause(String string, Integer ... integerArray) {
        if (integerArray.length == 1 && !string.trim().toLowerCase().endsWith("not")) {
            return "(" + string + " = " + integerArray[0].toString() + ")";
        }
        if (a) {
            return SQLStatementUtil.getORClause(string, integerArray, 4);
        }
        Arrays.sort((Object[])integerArray);
        StringBuilder stringBuilder = new StringBuilder(integerArray.length * 6);
        stringBuilder.append('(');
        String string2 = "";
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            int n2;
            int n3;
            int n4 = integerArray[i2];
            int n5 = i2;
            int n6 = 1;
            for (n3 = i2 + 1; n3 < integerArray.length && (n2 = integerArray[n3].intValue()) - 1 == n4; ++n3) {
                n4 = n2;
                ++n6;
            }
            if (n6 >= 10) {
                stringBuilder.append(string2);
                stringBuilder.append("((");
                stringBuilder.append(string);
                stringBuilder.append(">=");
                stringBuilder.append(integerArray[n5]);
                stringBuilder.append(") and (");
                stringBuilder.append(string);
                stringBuilder.append("<=");
                stringBuilder.append(integerArray[n5 + n6 - 1]);
                stringBuilder.append("))");
                for (n2 = n5; n2 < n5 + n6; ++n2) {
                    integerArray[n2] = null;
                }
                string2 = " or ";
            }
            i2 = n3 - 1;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n7 : integerArray) {
            if (n7 == null) continue;
            treeSet.add(n7);
        }
        if (!treeSet.isEmpty()) {
            String string3 = SQLStatementUtil.getORClause(string, treeSet);
            if (stringBuilder.length() > 1) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String getORClauseWithoutIn(String string, Object ... objectArray) {
        if (string == null || string.length() == 0 || objectArray == null || objectArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(objectArray[0].toString());
        int n2 = objectArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(" OR ");
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(objectArray[i2].toString());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String getORClause(Collection<String> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<String> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(" or ");
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String getOrClause(String[] stringArray, ObjectId[] objectIdArray) {
        if (stringArray.length == 1) {
            return SQLStatementUtil.getKeyORClause(stringArray[0], Arrays.asList(objectIdArray));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < objectIdArray.length; ++i2) {
            stringBuilder.append('(');
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                stringBuilder.append(stringArray[i3]).append(" = ").append(objectIdArray[i2].getPrimaryKeyObjects().get(i3));
                if (i3 == stringArray.length - 1) continue;
                stringBuilder.append(" AND ");
            }
            if (i2 != objectIdArray.length - 1) {
                stringBuilder.append(") OR ");
                continue;
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String getCommaSeparatedString(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String string;
            Object obj = iterator.next();
            if (obj == null || (string = obj.toString()) == null || (string = string.trim()).length() <= 0) continue;
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return null;
    }

    public static String escapeStringForEquals(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                stringBuilder.append('\'');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String escapeStringForLike(String string, DBType dBType) {
        return SQLStatementUtil.escapeStringForLike(string, dBType, true);
    }

    public static String escapeStringForLike(String string, DBType dBType, boolean bl) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '%' || c2 == '_' || c2 == '\\' || dBType == DBType.SqlServer && c2 == '[') {
                stringBuilder.append('\\');
            } else if (c2 == '\'' && bl) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String unescapeSQLForDisplay(String string, String string2, DBType dBType) {
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        if (string.indexOf("LIKE") != -1) {
            string2 = string2.replaceAll("\\\\([%_\\\\])", "$1");
            if (dBType == DBType.SqlServer) {
                string2 = string2.replaceAll("\\\\\\[", "[");
            }
        } else {
            string2 = string2.replaceAll("^'", "").replaceAll("'$", "");
        }
        return string2.replaceAll("''", "'");
    }

    public static String getObsProjJoinClause(String string) {
        return SQLStatementUtil.getObsProjJoinClause(string, "");
    }

    public static String getObsProjJoinClause(String string, String string2) {
        return string + " in (select obsproj.proj_id from obsproj, userobs where obsproj.obs_id = userobs.obs_id and userobs.user_id = ? " + string2 + ")";
    }

    public static String getObsProjJoinUnionOpenProjClause(ObjectId objectId, String string) {
        return string + " in (select obsproj.proj_id from obsproj, userobs where obsproj.obs_id = userobs.obs_id and userobs.user_id = ? union select proj_id from projshar where session_id = ?)";
    }
}

