/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

public enum ConnectionClass {
    SYSADMIN(true),
    SYSUSER(true),
    ADMINISTRATIVE,
    UTILITY,
    PX,
    REPORTING,
    PRIVILEGED,
    PUBUSER;

    public final boolean canBeSysDBA;

    private ConnectionClass() {
        this.canBeSysDBA = false;
    }

    private ConnectionClass(boolean sysDBA) {
        this.canBeSysDBA = sysDBA;
    }

    public static ConnectionClass fromString(String str) {
        return ConnectionClass.valueOf(ConnectionClass.getNormalizedString(str));
    }

    private static String getNormalizedString(String rawString) {
        if (rawString == null) {
            return "";
        }
        return rawString.toUpperCase();
    }
}

