/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.PropSet;
import com.primavera.database.tools.dbmt.ApplicationParamaterInitializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ApplicationInitParams {
    public static final String APP_RUNNER = "dbmt.application.runner";
    private static final String UNIX_STYLE_SHORT_INTRO = "-";
    private static final String UNIX_STYLE_LONG_INTRO = "--";
    private static final String WIN_STYLE_SHORT_INTO = "/";
    private static final Set<PropertyInitSpec> m_propInitSet = ApplicationInitParams.loadPropInitSpecs();
    private Map<String, CommandLineReader> m_cmdProcessorMap = new HashMap<String, CommandLineReader>();
    private Map<String, VariableReader> m_envProcessorMap = new HashMap<String, VariableReader>();
    private Map<String, VariableReader> m_prpProcessorMap = new HashMap<String, VariableReader>();
    private Map<String, String> m_cmdValueMap = new HashMap<String, String>();
    private Map<String, String> m_envValueMap = new HashMap<String, String>();
    private Map<String, String> m_prpValueMap = new HashMap<String, String>();

    public ApplicationInitParams() {
        for (PropertyInitSpec initSpec : m_propInitSet) {
            VariableReader pReader = initSpec.getPrpReader();
            VariableReader eReader = initSpec.getEnvReader();
            CommandLineReader cReader = initSpec.getCmdReader();
            if (pReader != null) {
                this.m_prpProcessorMap.put(initSpec.getPropertyName(), initSpec.getPrpReader());
            }
            if (eReader != null) {
                this.m_envProcessorMap.put(initSpec.getEnvVarName(), initSpec.getEnvReader());
            }
            if (cReader == null) continue;
            String shortParam = initSpec.getCmdLineShortParams();
            String longParam = initSpec.getCmdLineLongParams();
            if (shortParam != null) {
                this.m_cmdProcessorMap.put(UNIX_STYLE_SHORT_INTRO + initSpec.getCmdLineShortParams(), initSpec.getCmdReader());
                this.m_cmdProcessorMap.put(WIN_STYLE_SHORT_INTO + initSpec.getCmdLineShortParams(), initSpec.getCmdReader());
            }
            if (longParam == null) continue;
            this.m_cmdProcessorMap.put(UNIX_STYLE_LONG_INTRO + initSpec.getCmdLineLongParams(), initSpec.getCmdReader());
        }
    }

    public void writeToProperties(Properties prop) {
        Properties appProps = ApplicationProperties.getProps();
        for (Map.Entry<String, String> entry : this.m_prpValueMap.entrySet()) {
            appProps.put(entry.getKey(), entry.getValue());
        }
    }

    public void processCommandLine(String[] cmdLine) throws UsageException {
        int consumed;
        for (int i = 0; i < cmdLine.length; i += consumed) {
            CommandLineReader reader = this.m_cmdProcessorMap.get(cmdLine[i]);
            if (reader == null) {
                throw new UnknownCommandLineParameterException(cmdLine[i]);
            }
            consumed = reader.processCommandLine(this.m_cmdValueMap, cmdLine, i);
        }
    }

    public void processEnvironment() throws UsageException {
        for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
            VariableReader reader = this.m_envProcessorMap.get(envEntry.getKey());
            if (reader == null) continue;
            reader.processVariable(this.m_envValueMap, envEntry.getValue());
        }
    }

    public void processProperties(PropSet[] propSets) throws UsageException {
        for (PropSet propSet : propSets) {
            for (Map.Entry<Object, Object> propEntry : propSet.getProps().entrySet()) {
                this.m_prpValueMap.put(propEntry.getKey().toString(), propEntry.getValue().toString());
            }
        }
        for (Map.Entry entry : System.getProperties().entrySet()) {
            VariableReader reader = this.m_prpProcessorMap.get(entry.getKey().toString());
            if (reader == null) continue;
            reader.processVariable(this.m_prpValueMap, entry.getValue().toString());
        }
    }

    private static final Set<PropertyInitSpec> loadPropInitSpecs() {
        HashSet<PropertyInitSpec> propInitSet = new HashSet<PropertyInitSpec>();
        ApplicationParamaterInitializer.initializePropInitSet(propInitSet);
        return propInitSet;
    }

    public static class UsageException
    extends Exception {
        private static final long serialVersionUID = -6873467021886736476L;
    }

    public class UnknownCommandLineParameterException
    extends UsageException {
        private static final long serialVersionUID = 2195497874302942095L;
        private String m_parameter;

        public UnknownCommandLineParameterException(String param) {
            this.m_parameter = param;
        }

        @Override
        public String getMessage() {
            return "Unknown Command Line Parameter: " + this.m_parameter;
        }

        public String getParameter() {
            return this.m_parameter;
        }
    }

    public static class PropertyInitSpec {
        private String m_propertyName;
        private CommandLineReader m_cmdReader;
        private String m_cmdLineShortParams;
        private String m_cmdLineLongParams;
        private VariableReader m_envReader;
        private String m_envVarName;
        private VariableReader m_prpReader;

        public PropertyInitSpec(String propertyName, CommandLineReader cmdReader, String cmdLineShortParams, String cmdLineLongParams, VariableReader envReader, String envVarName, VariableReader prpReader) {
            this.m_propertyName = propertyName;
            this.m_cmdReader = cmdReader;
            this.m_cmdLineShortParams = cmdLineShortParams;
            this.m_cmdLineLongParams = cmdLineLongParams;
            this.m_envReader = envReader;
            this.m_envVarName = envVarName;
            this.m_prpReader = prpReader;
        }

        public String getCmdLineShortParams() {
            return this.m_cmdLineShortParams;
        }

        public CommandLineReader getCmdReader() {
            return this.m_cmdReader;
        }

        public VariableReader getEnvReader() {
            return this.m_envReader;
        }

        public String getEnvVarName() {
            return this.m_envVarName;
        }

        public String getPropertyName() {
            return this.m_propertyName;
        }

        public VariableReader getPrpReader() {
            return this.m_prpReader;
        }

        public String getCmdLineLongParams() {
            return this.m_cmdLineLongParams;
        }
    }

    public static interface VariableReader {
        public void processVariable(Map<String, String> var1, String var2) throws UsageException;
    }

    public static interface CommandLineReader {
        public int processCommandLine(Map<String, String> var1, String[] var2, int var3) throws UsageException;
    }
}

