/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.workflow.WorkflowStepJobFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaActions {
    private final Map<ActionClass, List<ParameterizedJobFactory<?>>> m_jobMap = new HashMap();

    public void addStep(ActionClass actionClass, WorkflowStepJobFactory job) {
        List<ParameterizedJobFactory<?>> jobs = this.m_jobMap.get(actionClass);
        if (jobs == null) {
            jobs = new ArrayList();
            this.m_jobMap.put(actionClass, jobs);
        }
        DBMTLogger.info(Channel.DEV, " ****** " + actionClass + " += " + job.toString());
        jobs.add(job);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<ActionClass, List<ParameterizedJobFactory<?>>> entry : this.m_jobMap.entrySet()) {
            sbuf.append(entry.getKey().toString() + " - {");
            for (ParameterizedJobFactory<?> job : entry.getValue()) {
                sbuf.append(" " + job.toString());
            }
            sbuf.append(" }\n");
        }
        return sbuf.toString();
    }

    public List<ParameterizedJobFactory<?>> getSteps(ActionClass action) {
        DBMTLogger.info(Channel.DEV, "ActionClass = " + action);
        List<ParameterizedJobFactory<?>> jobFactoryList = this.m_jobMap.get(action);
        if (jobFactoryList != null) {
            return jobFactoryList;
        }
        return new ArrayList();
    }
}

