/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.SchemaType;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.SchemaActions;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.workflow.nodes.SchemaNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaMap {
    private final Map<SchemaInfo, SchemaMapEntry> m_schemaMap = new HashMap<SchemaInfo, SchemaMapEntry>();

    public void add(JarFile jarFile) {
        SchemaInfoImpl info = SchemaInfoImpl.createFromFile(new File(jarFile.getName()));
        this.m_schemaMap.put(info, new SchemaMapEntry(jarFile));
    }

    public List<ParameterizedJobFactory<?>> get(SchemaInfo info, ActionClass action) {
        SchemaMapEntry entry = this.m_schemaMap.get(info);
        if (entry == null) {
            System.out.println("No Schemas Found for " + info);
            return new ArrayList();
        }
        return entry.getActions().getSteps(action);
    }

    public SchemaInfo[] getProductSchemas(SchemaType product) {
        ArrayList<SchemaInfo> infos = new ArrayList<SchemaInfo>();
        for (SchemaInfo info : this.m_schemaMap.keySet()) {
            if (info.getSchemaType() != product) continue;
            infos.add(info);
        }
        Object[] infoArray = new SchemaInfo[infos.size()];
        for (int i = 0; i < infos.size(); ++i) {
            infoArray[i] = (SchemaInfo)infos.get(i);
        }
        Arrays.sort(infoArray);
        return infoArray;
    }

    private SchemaActions createSchemaActions(JarFile file) {
        SchemaActions actions = new SchemaActions();
        String resourceLoc = this.getSchemaFileLocationFromJarFile(file);
        ZipEntry zipEntry = file.getEntry(resourceLoc);
        if (zipEntry == null) {
            return actions;
        }
        try {
            InputStream instream = file.getInputStream(zipEntry);
            if (instream != null) {
                try {
                    this.parseSchemaWorkflowFile(instream, actions);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return actions;
    }

    private void parseSchemaWorkflowFile(InputStream fileStream, SchemaActions actions) throws SAXException {
        NodeLink start = SchemaMap.createStartNode(actions);
        SimpleHandler handler = new SimpleHandler(start);
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(fileStream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSchemaFileLocationFromJarFile(JarFile file) {
        SchemaInfoImpl info = SchemaInfoImpl.createFromFileName(new File(file.getName()).getName());
        String maj = ProductVersion.format(info.getMajVersion());
        String min = ProductVersion.format(info.getMinVersion());
        String rel = ProductVersion.format(info.getRelVersion());
        String path = "install/" + (Object)((Object)info.getSchemaType()) + "_" + maj + "_" + min + "_" + rel + "/" + "SchemaWorkflow.xml";
        return path;
    }

    private static final NodeLink createStartNode(final SchemaActions actions) {
        return new NodeLink(){

            @Override
            public NodeHandler nextNode(String elemName, Attributes attr) {
                if ("schema".equals(elemName)) {
                    return new SchemaNode(attr, actions);
                }
                return null;
            }

            @Override
            public String path() {
                return "/";
            }
        };
    }

    private class SchemaMapEntry {
        private final JarFile m_jarFile;
        private final SchemaActions m_actions;

        public SchemaMapEntry(JarFile jarFile) {
            this.m_jarFile = jarFile;
            this.m_actions = SchemaMap.this.createSchemaActions(jarFile);
        }

        public String toString() {
            return this.m_actions.toString();
        }

        public final JarFile getJarFile() {
            return this.m_jarFile;
        }

        public final SchemaActions getActions() {
            return this.m_actions;
        }
    }
}

