/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class ServerLogic {
    static final Comparator<String> s_privUserComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            String name0 = arg0.toUpperCase();
            String name1 = arg1.toUpperCase();
            int privIndex0 = name0.indexOf("PRIV");
            int privIndex1 = name1.indexOf("PRIV");
            if (privIndex0 < 0 && privIndex1 < 0 || privIndex0 == privIndex1) {
                return name0.compareTo(name1);
            }
            if (privIndex0 < 0 || privIndex1 < 0) {
                return privIndex1 - privIndex0;
            }
            return privIndex0 - privIndex1;
        }
    };
    static final Comparator<String> s_pxrptUserComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            String name0 = arg0.toUpperCase();
            String name1 = arg1.toUpperCase();
            int privIndex0 = name0.indexOf("PXRPT");
            int privIndex1 = name1.indexOf("PXRPT");
            if (privIndex0 < 0 && privIndex1 < 0 || privIndex0 == privIndex1) {
                return name0.compareTo(name1);
            }
            if (privIndex0 < 0 || privIndex1 < 0) {
                return privIndex1 - privIndex0;
            }
            return privIndex0 - privIndex1;
        }
    };

    public static String getDefaultDirectory() {
        if (System.getProperty("sun.desktop").equals("windows")) {
            return "C:\\";
        }
        return "/";
    }

    public static String getDirectory(String text) {
        if (text == null || text.isEmpty()) {
            return ServerLogic.getDefaultDirectory();
        }
        String[] paths = text.split("/|\\\\");
        if (paths.length < 2) {
            return ServerLogic.getDefaultDirectory();
        }
        return text.trim().substring(0, text.length() - paths[paths.length - 1].length());
    }

    public abstract Set<DatabaseInfo> getDatabases(ServerInfo var1);

    public List<String> getSortedPossiblePrivusers(DatabaseConnection dbconn) {
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            this.getPossiblePrivusers(dbconn, usernames);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String[] userArray = usernames.toArray(new String[0]);
        Arrays.sort(userArray, s_privUserComparator);
        usernames.clear();
        for (String username : userArray) {
            usernames.add(username);
            StringLocalizer.setAsOwnTranslation(username);
        }
        return usernames;
    }

    protected abstract ResultSet getPrivUsersResultSet(DatabaseConnection var1) throws SQLException;

    protected abstract ResultSet getPubUsersResultSet(DatabaseConnection var1) throws SQLException;

    protected abstract ResultSet getPxrptUsersResultSet(DatabaseConnection var1) throws SQLException;

    public List<String> getSortedPossiblePxrptusers(DatabaseConnection dbconn) {
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            this.getPossiblePxrptusers(dbconn, usernames);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String[] userArray = usernames.toArray(new String[0]);
        Arrays.sort(userArray, s_pxrptUserComparator);
        usernames.clear();
        for (String username : userArray) {
            usernames.add(username);
            StringLocalizer.setAsOwnTranslation(username);
        }
        return usernames;
    }

    protected abstract void getPossiblePxrptusers(DatabaseConnection var1, List<String> var2) throws SQLException;

    protected abstract void getPossiblePrivusers(DatabaseConnection var1, List<String> var2) throws SQLException;

    public abstract List<String> getSortedPossiblePubusers(DatabaseConnection var1);

    protected abstract String getPrivUsersSQL();

    protected abstract String getPxtUsersSQL();

    protected abstract String getPubUsersSQL();

    static class UserNameAndGrantCount {
        private final String m_userName;
        private final int m_grantCnt;

        public UserNameAndGrantCount(String userName, int grantCnt) {
            this.m_userName = userName;
            this.m_grantCnt = grantCnt;
        }

        protected final int getGrantCnt() {
            return this.m_grantCnt;
        }

        protected final String getUserName() {
            return this.m_userName;
        }
    }
}

