/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.tools.dbmt.AbstractJob;
import java.util.ArrayList;
import java.util.List;

public class WorkflowStepJob
extends AbstractJob {
    private final List<Job> m_jobs = new ArrayList<Job>();
    private final String m_name;
    private final String m_maxVersion;

    @Override
    public String getMaxVersion() {
        return this.m_maxVersion;
    }

    public WorkflowStepJob(String stepName, String maxVersion, List<Job> jobs) {
        this.m_name = stepName;
        this.m_jobs.addAll(jobs);
        this.m_maxVersion = maxVersion;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return true;
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        for (Job job : this.m_jobs) {
            if (job.execute(listener, watcher)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Job> subjobs() {
        return this.m_jobs;
    }

    public String toString() {
        return this.m_name;
    }
}

