/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.List;

public class AddCRUpgradeJobs
extends AbstractJobAdder {
    private static final String INITIAL_PM_CONTENT_REPOSITORY_VERSION = "0602.0005.0001.0001";
    private final ApplicationContextLogic m_contextLogic;

    public AddCRUpgradeJobs(String pageId, ApplicationContextLogic contextLogic) {
        super(pageId);
        this.m_contextLogic = contextLogic;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        ActionClass createActionClass = AbstractJobAdder.getActionClass(ActionType.INSTALL, jobProps);
        List<SchemaInfo> schemas = AbstractJobAdder.getSchemaInfo(jobProps);
        Object upgradingSchemaType = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY);
        for (SchemaInfo schemaInfo : schemas) {
            if (schemaInfo.getSchemaType() != SchemaType.JR || upgradingSchemaType != SchemaType.EXPADM && upgradingSchemaType != SchemaType.PM) continue;
            String upgradeSchema = (String)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY);
            if (upgradingSchemaType == SchemaType.PM && upgradeSchema.compareTo(INITIAL_PM_CONTENT_REPOSITORY_VERSION) >= 0) continue;
            List<ParameterizedJobFactory<?>> jobFactories = this.m_contextLogic.getApp().getSchemaSteps(schemaInfo, createActionClass);
            for (ParameterizedJobFactory<?> factory : jobFactories) {
                Object job = factory.createJob(jobProps);
                jobs.add((Job)job);
            }
        }
    }
}

