/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class AddReportingConnectionTransOp
extends SetConnectStringTransOp {
    public AddReportingConnectionTransOp(boolean verify, Properties fieldOverrides) {
        super(ConnectionClass.REPORTING, verify, fieldOverrides);
    }

    public AddReportingConnectionTransOp(boolean verify) {
        this(verify, new Properties());
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pxrptUserName = null;
        String pxrptPassword = null;
        if ("true".equalsIgnoreCase(data.getPageData(page).getValue("useexistingpxrptuser"))) {
            pxrptUserName = data.getPageData(page).getValue("existingPxrpt");
            pxrptPassword = "configure_px_users".equals(page) ? data.getPageData(page).getValue("pxrptpasslist") : data.getPageData(page).getValue("pxrptpass");
        } else {
            pxrptUserName = data.getPageData(page).getValue("pxrptuser");
            pxrptPassword = data.getPageData(page).getValue("pxrptpass");
        }
        String sExists = Boolean.FALSE.toString();
        try {
            sExists = data.getPageData(page).getValue("pxrptuser_exists");
        }
        catch (InvalidDialogField invalidDialogField) {
            // empty catch block
        }
        if (!Boolean.parseBoolean(sExists)) {
            this.m_verify = false;
        }
        String adminConnection = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        return this.createConnectionFromExistingConnectionForNewUser(adminConnection, pxrptUserName, pxrptPassword);
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pxrptUserName = null;
        String pxrptPassword = null;
        if ("true".equalsIgnoreCase(data.getPageData(page).getValue("useexistingpxrptuser"))) {
            pxrptUserName = data.getPageData(page).getValue("existingPxrpt");
            pxrptPassword = "configure_px_users".equals(page) ? data.getPageData(page).getValue("pxrptpasslist") : data.getPageData(page).getValue("pxrptpass");
        } else {
            pxrptUserName = data.getPageData(page).getValue("pxrptuser");
            pxrptPassword = data.getPageData(page).getValue("pxrptpass");
        }
        String sExists = Boolean.FALSE.toString();
        try {
            sExists = data.getPageData(page).getValue("pxrptuser_exists");
        }
        catch (InvalidDialogField invalidDialogField) {
            // empty catch block
        }
        if (!Boolean.parseBoolean(sExists)) {
            this.m_verify = false;
        }
        String adminConnection = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnection);
        String dbService = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setDatabase(dbService);
        info.setUsername(pxrptUserName);
        String connectString = parsedAdminConnection.getConnectstring();
        return info.createATPConnectString(pxrptPassword, connectString);
    }
}

