/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.BaseServerInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.actions.DialogActionOperation;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.ArrayList;

public class AddServerAction
extends DialogActionOperation<ApplicationContextLogic> {
    public AddServerAction(ApplicationContextLogic logic) {
        super(logic);
    }

    @Override
    public void performDialogAction(InteractorData data) throws InteractorDataError {
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        ServerType type = this.getType(data.getString("vendor"));
        if (type == null) {
            return;
        }
        BaseServerInfo server = this.createServerInfo(type, data);
        if (server == null) {
            return;
        }
        server.setPort(Integer.parseInt(data.getString("port")));
        server.setUsername(data.getString("login"));
        servers.add(server);
        ((ApplicationContextLogic)this.contextLogic()).getApp().addServers(servers);
    }

    private BaseServerInfo createServerInfo(ServerType type, InteractorData data) throws InteractorDataError {
        if (type == ServerType.SQLSERVER) {
            return new MSSqlServerInfo(data.getString("display"), data.getString("hostname"));
        }
        if (type == ServerType.ORACLE) {
            return new OracleServerInfo(data.getString("display"), data.getString("hostname"), data.getString("instance"));
        }
        return null;
    }

    private ServerType getType(String serverId) {
        if (serverId.toUpperCase().equals("ORACLE")) {
            return ServerType.ORACLE;
        }
        if (serverId.toUpperCase().equals("MSSQL")) {
            return ServerType.SQLSERVER;
        }
        return null;
    }
}

