/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.RunnerFactoryManager;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.CmdLineWizardRunnerFactory;
import java.util.List;

public class CreateKeyStoreJob
extends AbstractJobAdder {
    private final ApplicationContextLogic m_contextLogic;
    private final String pageId;

    public CreateKeyStoreJob(String pageId, ApplicationContextLogic contextLogic) {
        super(pageId);
        this.pageId = pageId;
        this.m_contextLogic = contextLogic;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        if (RunnerFactoryManager.inst().getWizardRunnerFactory().getClass().equals(CmdLineWizardRunnerFactory.class)) {
            return;
        }
        ActionClass usersActionClass = AbstractJobAdder.getActionClass(ActionType.KEYSTORE, jobProps);
        for (SchemaInfo schemaInfo : AbstractJobAdder.getSchemaInfo(jobProps)) {
            List<ParameterizedJobFactory<?>> jobFactories = this.m_contextLogic.getApp().getSchemaSteps(schemaInfo, usersActionClass);
            for (ParameterizedJobFactory<?> factory : jobFactories) {
                Object job = factory.createJob(jobProps);
                if (job == null) continue;
                jobs.add((Job)job);
            }
        }
    }
}

