/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.DialogActionOperation;
import com.primavera.database.tools.dbmt.actions.InteractorDataDef;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionOperationFactory;
import java.lang.reflect.InvocationTargetException;

public class DialogFactory
implements ActionOperationFactory {
    private final InteractorDataDef m_dataDef;

    public DialogFactory(InteractorDataDef dataDef) {
        this.m_dataDef = dataDef;
    }

    @Override
    public DialogActionOperation<?> createAction(String actionClassName, String contextClassName, String actionPath, String nameKey, String descKey) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class<?> actionClass = Class.forName(actionClassName);
        Class<?> contextClass = Class.forName(contextClassName);
        Object contextObject = contextClass.newInstance();
        Object actionObject = actionClass.getConstructor(contextClass).newInstance(contextObject);
        if (actionObject instanceof DialogActionOperation) {
            DialogActionOperation action = (DialogActionOperation)actionObject;
            action.setDataDef(this.m_dataDef);
            action.setActionPath(actionPath);
            action.setNameKey(nameKey);
            action.setDescKey(descKey);
            return action;
        }
        DBMTLogger.error(Channel.USER, "Class " + actionClassName + " is not a " + DialogActionOperation.class.getName() + " for action " + actionPath);
        return null;
    }
}

