/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.tests.TestOp;
import java.util.ArrayList;
import java.util.List;

public class FieldTester {
    private final TestOp m_testOp;
    private final List<String> m_fields = new ArrayList<String>();
    private final List<String> m_params = new ArrayList<String>();
    private final Object m_context;

    public FieldTester(TestOp testOp, List<String> fields, List<String> params, Object context) {
        this.m_testOp = testOp;
        this.m_fields.addAll(fields);
        this.m_params.addAll(params);
        this.m_context = context;
    }

    public final boolean doTest(InteractorData data) throws InteractorDataError {
        return this.m_testOp.validate(this.m_context, data, this.m_fields, this.m_params);
    }

    public final String getReason(InteractorData data) {
        String reasonKey = this.m_testOp.getClass().getCanonicalName();
        if (reasonKey == null) {
            return "Unknown Reason";
        }
        try {
            String[] reasonParams = this.m_testOp.reasonParams(data, this.m_fields, this.m_params);
            return StringLocalizer.get(reasonKey, reasonParams);
        }
        catch (InteractorDataError e) {
            String localizedErrorMessage = StringLocalizer.get("dbmt.error.testreasonthrewerror", new String[]{this.m_testOp.getClass().getPackage().getName(), this.m_testOp.getClass().getSimpleName()});
            DBMTLogger.error(Channel.USER, localizedErrorMessage, e);
            return localizedErrorMessage;
        }
    }

    public List<String> getFields() {
        return this.m_fields;
    }

    public List<String> getParams() {
        return this.m_params;
    }
}

