/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class InitializeORExpUsersPage
implements TransitionMap.PageInitializer {
    private static final String FIELD_ID_USERNAME = "username";
    private static final String FIELD_ID_PASSWORD = "password";
    private static final ConnectionClass CONNECTION_CLASS = ConnectionClass.SYSADMIN;

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        Object schema = jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY);
        if (schema == SchemaType.EXP) {
            data.getPageData(page).setValue(FIELD_ID_USERNAME, "exp");
            data.getPageData(page).setValue(FIELD_ID_PASSWORD, "sql");
        } else if (schema == SchemaType.EXPADM) {
            data.getPageData(page).setValue(FIELD_ID_USERNAME, "expadmin");
            data.getPageData(page).setValue(FIELD_ID_PASSWORD, "expadmin");
        } else {
            return StringLocalizer.get("dbmt.action.error.invalidschematype", new String[]{schema.toString()});
        }
        String connectionString = jobProps.getConnection(CONNECTION_CLASS);
        HashSet<String> existingOracleUsers = new HashSet<String>();
        existingOracleUsers.addAll(InitializeORExpUsersPage.getExistingUsers(connectionString));
        data.getPageData(page).setValue(FIELD_ID_USERNAME, OracleLogic.getDefaultOracleUserName(existingOracleUsers, data.getValue(page, FIELD_ID_USERNAME)));
        return null;
    }

    public static Set<String> getExistingUsers(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            Set<String> set = OracleLogic.getExistingUsers(conn);
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

