/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.workflow.DatapumpJob;
import java.util.HashSet;

public class InitializePXUsersPage
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectStringName;
    private final String[][] m_userNameAndPassFields;
    private static final String PXRPTUSER_EXISTS = "pxrptuser_exists";

    public InitializePXUsersPage(ConnectionClass connectStringName, String[][] userNameAndPassFields) {
        this.m_connectStringName = connectStringName;
        this.m_userNameAndPassFields = userNameAndPassFields;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError, DBMTException {
        HashSet<String> existingUsers = new HashSet<String>();
        String connectionString = null;
        boolean isSqlServer = !PageInitializerHelper.isOracle(jobProps, data);
        data.getPageData(page).setValue("isSqlServer", Boolean.toString(isSqlServer));
        boolean isUpgrade = PageInitializerHelper.isUpgrade(jobProps, data);
        data.getPageData(page).setValue("isupgrade", Boolean.toString(isUpgrade));
        boolean val = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM;
        boolean versionAlreadyHasPxrptUser = PageInitializerHelper.hasPxrptuser(jobProps, data);
        boolean pxrptuserExists = val && versionAlreadyHasPxrptUser;
        data.getPageData(page).setValue(PXRPTUSER_EXISTS, Boolean.toString(pxrptuserExists));
        boolean isInstall = PageInitializerHelper.isInstall(jobProps, data);
        DatapumpJob.toLoad(isInstall);
        try {
            connectionString = jobProps.getConnection(this.m_connectStringName);
        }
        catch (ConnectionNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.ORACLE) {
            existingUsers.addAll(OracleLogic.getExistingUsers(connectionString));
        } else if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.SQLSERVER) {
            existingUsers.addAll(SqlServerLogic.getExistingUsers(connectionString));
        }
        String value = null;
        for (String[] fieldIds : this.m_userNameAndPassFields) {
            if (fieldIds == null || fieldIds.length == 0) continue;
            if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.ORACLE) {
                value = OracleLogic.getDefaultOracleUserName(existingUsers, data.getValue(page, fieldIds[0]));
            } else if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.SQLSERVER) {
                value = SqlServerLogic.getDefaultSSUserName(existingUsers, data.getValue(page, fieldIds[0]));
            }
            data.getPageData(page).setValue(fieldIds[0], value);
        }
        return null;
    }
}

