/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.AbstractJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.sql.BLOB;

public class LoadLicenseFileJob
extends AbstractJob {
    private static final String STR_LIC_FORMAT_HEADER = "BEGIN -- Primavera Product License Key";
    private static final String STR_LIC_FORMAT_FOOTER = "END   -- Primavera Product License Key";
    private static final String STR_LIC_FORMAT_BODY = "DATA  -- ";
    private final File m_licenseFile;
    private final String m_connectString;
    private final ServerType m_serverType;
    BLOB m_blobdata = null;

    public LoadLicenseFileJob(File licenseFile, String connectString, ServerType serverType) {
        this.m_licenseFile = licenseFile;
        this.m_connectString = connectString;
        this.m_serverType = serverType;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    public String toString() {
        return StringLocalizer.get("dbmt.sql.job.licensefilename", new String[]{this.m_licenseFile.getPath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        String plainTextLicenseData = this.getRawLicenseData();
        DatabaseConnection connection = new DatabaseConnection(this.m_connectString);
        try {
            PreparedStatement stmt = connection.getConnection().prepareStatement("UPDATE prefer SET license_data = ?");
            this.setBlobData(plainTextLicenseData, stmt, 1);
            if (!watcher.isContinue()) {
                boolean bl = false;
                return bl;
            }
            stmt.execute();
        }
        finally {
            if (this.m_blobdata != null && this.m_blobdata.isOpen()) {
                this.m_blobdata.close();
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        return true;
    }

    private String getRawLicenseData() throws Exception {
        FileInputStream file = new FileInputStream(this.m_licenseFile);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(file));
        StringBuffer fileContent = new StringBuffer();
        String nextLine = null;
        boolean inLicenseData = false;
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("//")) continue;
            if (nextLine.equals(STR_LIC_FORMAT_HEADER)) {
                inLicenseData = true;
                continue;
            }
            if (nextLine.equals(STR_LIC_FORMAT_FOOTER)) {
                inLicenseData = false;
                continue;
            }
            if (!inLicenseData) continue;
            String nextLicDataSegment = nextLine.substring(STR_LIC_FORMAT_BODY.length());
            fileContent.append(nextLicDataSegment + "\r\n");
        }
        return fileContent.toString();
    }

    private void setBlobData(String blobData, PreparedStatement stmt, int columnNumber) throws Exception {
        if (this.m_serverType == ServerType.ORACLE) {
            if (this.m_blobdata != null && this.m_blobdata.isOpen()) {
                this.m_blobdata.close();
            }
            this.m_blobdata = BLOB.createTemporary(stmt.getConnection(), false, 10);
            this.m_blobdata.setBytes(1L, blobData.getBytes());
            stmt.setBlob(columnNumber, this.m_blobdata);
            return;
        }
        if (this.m_serverType == ServerType.SQLSERVER) {
            stmt.setString(columnNumber, blobData);
            return;
        }
        throw new Exception("Unknown Database Type: " + (Object)((Object)this.m_serverType));
    }
}

