/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.HashSet;

public abstract class PropertyWizardNavigationAction<T extends ContextLogic>
extends WizardActionOperation<T> {
    private final TransitionMap m_transitions = new TransitionMap();

    public PropertyWizardNavigationAction(T contextLogic) {
        super(contextLogic);
    }

    @Override
    public String tryToLeavePage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPageId) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        DBMTLogger.info(Channel.DEV, "TRANSITION: " + fromPageId + " -> " + toPageId);
        HashSet<String> results = new HashSet<String>();
        if (!this.m_transitions.validate(fromPageId, toPageId, data, jobProps, results)) {
            return (String)results.iterator().next();
        }
        this.m_transitions.perform(fromPageId, toPageId, runner, data, jobProps, results);
        if (!results.isEmpty()) {
            return (String)results.iterator().next();
        }
        try {
            this.m_transitions.initialize(toPageId, jobProps, runner, data, results);
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
        }
        if (!results.isEmpty()) {
            return (String)results.iterator().next();
        }
        return null;
    }

    @Override
    public String postProcess(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String page) {
        for (TransitionMap.TransitionOperation proc : this.m_transitions.getPagePostProcessors(page)) {
            try {
                DBMTLogger.info(Channel.DEV, "Calling page post processor " + proc.getClass().getSimpleName());
                String result = proc.process(runner, data, page, jobProps);
                if (result == null) continue;
                return result;
            }
            catch (ConnectionNotFoundException e) {
                DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.postprocessor.error", new String[]{page, e.getLocalizedMessage()}), e);
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            catch (InteractorDataError e) {
                DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.postprocessor.error", new String[]{page, e.getLocalizedMessage()}), e);
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            catch (ValueNotFound e) {
                DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.postprocessor.error", new String[]{page, e.getLocalizedMessage()}), e);
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            catch (DBMTException e) {
                DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.postprocessor.error", new String[]{page, e.getLocalizedMessage()}), e);
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
        }
        return null;
    }

    @Override
    public void undoPage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPage) throws InteractorDataError {
        this.m_transitions.undo(runner, fromPageId, toPage, jobProps);
    }

    public TransitionMap getTransitions() {
        return this.m_transitions;
    }
}

