/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.HashSet;

public class SSDatabaseDoesNotExist
implements TransitionMap.TransitionValidator {
    private final ConnectionClass m_connectionClass;
    private final String m_fieldName;

    public SSDatabaseDoesNotExist(ConnectionClass connectionClass, String dbNameFieldName) {
        this.m_connectionClass = connectionClass;
        this.m_fieldName = dbNameFieldName;
    }

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String connnectString = jobProps.getConnection(this.m_connectionClass);
        HashSet<String> set = new HashSet<String>();
        try {
            set.addAll(SqlServerLogic.getDatabaseNames(new DatabaseConnection(connnectString)));
        }
        catch (SQLException e) {
            DBMTLogger.info(Channel.DEV, "Error retrieving database names", e);
            return e.getLocalizedMessage();
        }
        String databaseName = data.getValue(page, this.m_fieldName);
        for (String dbName : set) {
            if (!dbName.equalsIgnoreCase(databaseName)) continue;
            return StringLocalizer.get("dbmt.error.install.databaseexists", new String[]{databaseName});
        }
        return null;
    }
}

