/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UknownSchemaTypeException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetExpSchemaTypeTransOp
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        jobProps.setJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY, this.getSchemaType(data.getValue(page, "database")));
        return null;
    }

    private Object getSchemaType(String string) throws DBMTException {
        if ("exp".equalsIgnoreCase(string)) {
            return SchemaType.EXP;
        }
        if ("admin".equalsIgnoreCase(string)) {
            return SchemaType.EXPADM;
        }
        throw new UknownSchemaTypeException(string);
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY);
    }
}

