/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.KeyStoreInstaller;
import com.primavera.common.StrUtil;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetKeyStoreFolder
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String keyStoreFolder = StrUtil.trim((String)data.getValue(page, "keyStoreFolder"));
        jobProps.setJobProperty("keyStoreFolder", "");
        if (!StrUtil.isEmpty((String)keyStoreFolder)) {
            KeyStoreInstaller ks = new KeyStoreInstaller();
            boolean verified = ks.verifyPassFile(keyStoreFolder);
            if (!verified) {
                return StringLocalizer.get("dbmt.error.keystore.validation.failed");
            }
            jobProps.setJobProperty("keyStoreFolder", data.getValue(page, "keyStoreFolder"));
            System.setProperty("primavera.bootstrap.home", StrUtil.trim((String)data.getValue(page, "keyStoreFolder")));
        }
        return null;
    }

    private boolean isKeyStoreFolderDefault(String keyStoreFolder) {
        boolean isDefaultPath = false;
        String defaultPath = System.getProperty("user.dir");
        if (keyStoreFolder.equalsIgnoreCase(defaultPath)) {
            isDefaultPath = true;
        }
        return isDefaultPath;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty("keyStoreFolder");
        System.clearProperty("primavera.bootstrap.home");
    }
}

