/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;

public class SetOracleConnectionLogon
extends SetConnectStringTransOp {
    private final String m_connectionPageId;

    public SetOracleConnectionLogon(ConnectionClass connection, String connectionPageId) {
        super(connection, false);
        this.m_connectionPageId = connectionPageId;
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProperties) throws InteractorDataError {
        String host = data.getValue(this.m_connectionPageId, "host");
        String port = data.getValue(this.m_connectionPageId, "port");
        String instance = data.getValue(this.m_connectionPageId, "instance");
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setHost(host);
        info.setPort(Integer.parseInt(port));
        info.setDatabase(instance);
        info.setUsername(this.getUsername(page, data));
        info.setService(data.getValue(this.m_connectionPageId, "ctype").equalsIgnoreCase("SERVICE"));
        return info.createConnectString(this.getPassword(page, data));
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, DBMTException {
        String configFile = this.getFieldId("dbwallet");
        String service = this.getFieldId("service");
        String username = this.getUsername(page, data);
        String dbService = data.getValue(this.m_connectionPageId, service);
        String password = this.getPassword(page, data);
        String dbConfigFilePath = data.getValue(this.m_connectionPageId, configFile);
        String connectString = "";
        connectString = dbConfigFilePath.contains(".zip") ? username + "/" + password + "@oracle_atp:" + dbConfigFilePath.substring(0, dbConfigFilePath.indexOf(".zip")) + ":" + dbService : username + "/" + password + "@oracle_atp:" + dbConfigFilePath + ":" + dbService;
        return connectString;
    }

    protected String getUsername(String pageId, WizardInteractorData data) throws InteractorDataError {
        return data.getValue(pageId, "admuser");
    }

    protected String getPassword(String pageId, WizardInteractorData data) throws InteractorDataError {
        return data.getValue(pageId, "admpass");
    }
}

