/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UnknownProductSuiteException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.TablespaceNotFoundException;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;

public class SetOracleTablespacesForUpgrade
implements TransitionMap.TransitionOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        DatabaseConnection connection = null;
        try {
            String dbAppAbrev = this.getApplicationAbreviation(jobProps);
            connection = new DatabaseConnection(jobProps.getConnection(ConnectionClass.ADMINISTRATIVE));
            OracleLogic.TablespaceSet pmdbTablespaces = OracleLogic.getPmdbTablespaces(connection);
            jobProps.getScriptProperties().setProperty(dbAppAbrev + ".data_tablespace", pmdbTablespaces.getDataTablespaceName());
            jobProps.getScriptProperties().setProperty(dbAppAbrev + ".index_tablespace", pmdbTablespaces.getIndexTablespaceName());
            jobProps.getScriptProperties().setProperty(dbAppAbrev + ".lob_tablespace", pmdbTablespaces.getLobTablespaceName());
            jobProps.getScriptProperties().setProperty(dbAppAbrev + ".px_tablespace", pmdbTablespaces.getPxTablespaceName());
        }
        catch (SQLException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            return string;
        }
        catch (TablespaceNotFoundException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            return string;
        }
        catch (UnknownProductSuiteException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")");
                }
            }
        }
        return null;
    }

    private String getApplicationAbreviation(JobProperties jobProps) throws JobPropertyNotFound, UnknownProductSuiteException {
        Object productSuiteType = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY);
        if (productSuiteType == ProductSuiteType.PM || productSuiteType == ProductSuiteType.PPM) {
            return jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY).toString().toLowerCase();
        }
        throw new UnknownProductSuiteException(jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

