/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SchemaValidationOptionKeys;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetPrivilegedUserName
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String privUser = data.getValue(page, "privuser");
        jobProps.setJobProperty(SchemaValidationOptionKeys.PRIVILEGED_USER_NAME_KEY, privUser);
        jobProps.getScriptProperties().put("pm.or.privileged_user", privUser);
        jobProps.getScriptProperties().put("mm.or.privileged_user", privUser);
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(SchemaValidationOptionKeys.PRIVILEGED_USER_NAME_KEY);
    }
}

