/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import java.util.Properties;

public class SetSqlServerConnectStringTransOp
extends SetConnectStringTransOp {
    public SetSqlServerConnectStringTransOp(ConnectionClass connectionId, boolean verify, Properties fieldOverrides) {
        super(connectionId, verify, fieldOverrides);
    }

    public SetSqlServerConnectStringTransOp(ConnectionClass connectionId, boolean verify) {
        super(connectionId, verify);
    }

    protected String getDatabaseName(WizardInteractorData data, String page) throws InteractorDataError {
        String instance = this.getFieldId("database");
        return data.getValue(page, instance);
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProperties) throws InteractorDataError {
        String pageId = this.getPageId(page);
        String host = this.getFieldId("host");
        String port = this.getFieldId("port");
        String username = this.getUsername();
        String password = this.getPassword();
        MSSqlServerInfo info = new MSSqlServerInfo("", "");
        info.setHost(data.getValue(pageId, host));
        info.setPort(Integer.parseInt(data.getValue(pageId, port)));
        info.setUsername(data.getValue(pageId, username));
        info.setDatabase(this.getDatabaseName(data, page));
        return info.createConnectString(data.getValue(pageId, password));
    }

    protected String getPassword() {
        return this.getFieldId("password");
    }

    protected String getUsername() {
        return this.getFieldId("username");
    }

    protected String getPageId(String page) {
        return page;
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        return this.createConnectString(data, page, jobProps);
    }
}

