/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import java.util.ArrayList;
import java.util.List;

public class TextDefinition {
    private final String m_textKey;
    private final List<String> m_substitutions = new ArrayList<String>();

    public TextDefinition(String textKey, List<String> substitutionKeys) {
        this.m_textKey = textKey;
        this.m_substitutions.addAll(substitutionKeys);
    }

    public final String getTextKey() {
        return this.m_textKey;
    }

    public final String getInterpolatedString(JobProperties props) {
        String[] substValues = new String[this.m_substitutions.size()];
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            String key = this.m_substitutions.get(i);
            Object value = null;
            try {
                value = props.getJobProperty(key);
            }
            catch (JobPropertyNotFound e) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.interactor.text.nosubst", new String[]{key}));
                value = "${" + key + "}";
            }
            if (value == null) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.interactor.text.nosubst", new String[]{key}));
                value = "${" + key + "}";
            }
            substValues[i] = value.toString();
        }
        return StringLocalizer.get(this.m_textKey, substValues);
    }
}

