/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class ValidateAdminUserPassword
implements TransitionMap.TransitionOperation {
    public final String wizardField;
    public final String propertyName;
    PasswordPolicySettings m_settings = new PasswordPolicySettings(true);

    public ValidateAdminUserPassword(String wname, String pname) {
        this.wizardField = wname;
        this.propertyName = pname;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        try {
            String password = data.getValue(page, this.wizardField);
            if (!this.isValid(password)) {
                throw new RuntimeException(StringLocalizer.get("dbmt.error.adminpasswordvalidationfailed"));
            }
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }

    public boolean isValid(String password) {
        if (password == null || password.length() < this.m_settings.getMinLength() || password.length() > this.m_settings.getMaxLength()) {
            return false;
        }
        int numDigits = 0;
        int numAlpha = 0;
        for (int i = 0; i < password.length(); ++i) {
            char ch = password.charAt(i);
            if (Character.isDigit(ch)) {
                ++numDigits;
                continue;
            }
            if (!Character.isLetter(ch)) continue;
            ++numAlpha;
        }
        return numDigits >= this.m_settings.getNumRequiredDigits() && numAlpha >= this.m_settings.getNumRequiredAlpha();
    }

    class PasswordPolicySettings {
        private static final int DEFAULT_MIN_LENGTH = 8;
        private static final int DEFAULT_MAX_LENGTH = 20;
        private static final int DEFAULT_REQUIRED_ALPHA = 1;
        private static final int DEFAULT_REQUIRED_DIGITS = 1;
        private int m_minLength = 8;
        private int m_maxLength = 20;
        private int m_numRequiredAlpha = 1;
        private int m_numRequiredDigits = 1;
        private boolean m_isPolicyStrict = true;

        public PasswordPolicySettings() {
        }

        public PasswordPolicySettings(boolean strictPolicy) {
            if (!strictPolicy) {
                this.m_minLength = 1;
                this.m_maxLength = 20;
                this.m_numRequiredAlpha = 0;
                this.m_numRequiredDigits = 0;
                this.m_isPolicyStrict = strictPolicy;
            }
        }

        public int getMinLength() {
            return this.m_minLength;
        }

        public int getMaxLength() {
            return this.m_maxLength;
        }

        public int getNumRequiredAlpha() {
            return this.m_numRequiredAlpha;
        }

        public int getNumRequiredDigits() {
            return this.m_numRequiredDigits;
        }

        public String getMaxLengthError() {
            return "txt.passwordLengthExceeded";
        }

        public String getValidationError() {
            return this.m_isPolicyStrict ? "msg.user.password.policy" : "msg.user.password.validtion.without.password.policy";
        }
    }
}

