/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.ContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.DataAccessFailureFailed;
import com.primavera.database.tools.dbmt.WizardActionLogic;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.RunnerFactoryManager;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardInteractorDataDef;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public abstract class WizardActionOperation<T extends ContextLogic>
implements ActionOperation,
WizardActionLogic {
    private WizardInteractorDataDef m_dataDef;
    private String m_path;
    private String m_nameKey;
    private String m_descKey;
    private T m_contextLogic;

    public WizardActionOperation(T contextLogic) {
        this.m_contextLogic = contextLogic;
    }

    @Override
    public final String getDescKey() {
        return this.m_descKey;
    }

    public final void setDescKey(String descKey) {
        this.m_descKey = descKey;
    }

    @Override
    public final String getNameKey() {
        return this.m_nameKey;
    }

    public final void setNameKey(String nameKey) {
        this.m_nameKey = nameKey;
    }

    public final WizardInteractorDataDef getDataDef() {
        return this.m_dataDef;
    }

    public final void setDataDef(WizardInteractorDataDef dataDef) {
        this.m_dataDef = dataDef;
    }

    @Override
    public final String getActionPath() {
        return this.m_path;
    }

    public final void setActionPath(String path) {
        this.m_path = path;
    }

    public T contextLogic() {
        return this.m_contextLogic;
    }

    @Override
    public final void perform() throws ActionFailed {
        WizardInteractorData data = new WizardInteractorData(this.m_dataDef);
        this.prepareData(data);
        WizardRunner runner = RunnerFactoryManager.inst().getWizardRunnerFactory().createWizardRunner(data, this.m_path);
        if (runner.runWizard(this)) {
            try {
                this.performWizardAction(data);
            }
            catch (InteractorDataError e) {
                throw new DataAccessFailureFailed(this, e);
            }
        }
    }

    public abstract void performWizardAction(WizardInteractorData var1) throws ActionFailed, InteractorDataError;

    @Override
    public String tryToFinish(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String pageId) {
        return null;
    }

    @Override
    public String tryToLeavePage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPageId) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        return null;
    }

    @Override
    public void preparePage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String pageId) throws InteractorDataError {
    }

    @Override
    public void undoPage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPageId) throws InteractorDataError {
    }

    @Override
    public void prepareData(WizardInteractorData data) {
    }

    public String postProcess(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String page) {
        return null;
    }
}

