/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorPageDef;
import com.primavera.database.tools.dbmt.actions.NextOp;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WizardInteractorDataDef {
    private final Map<String, InteractorPageDef> m_interactorDataDefMap = new HashMap<String, InteractorPageDef>();
    private final String m_nameKey;
    private final String m_descKey;
    private final Map<String, NextOp> m_forwardMap = new HashMap<String, NextOp>();
    private final Map<String, Set<FieldTester>> m_forwardValidators = new HashMap<String, Set<FieldTester>>();
    private final Map<String, Set<String>> m_forwardDepenencies = new HashMap<String, Set<String>>();
    private final Collection<String> m_finishablePages = new HashSet<String>();
    private final Collection<String> m_previousablePages = new HashSet<String>();
    private final Collection<String> m_commitPages = new HashSet<String>();
    private final Map<String, WizardNavigationAction> m_nextActionMap = new HashMap<String, WizardNavigationAction>();
    private String m_first;

    public WizardInteractorDataDef(String nameKey, String descKey) {
        this.m_nameKey = nameKey;
        this.m_descKey = descKey;
    }

    public final String getNameKey() {
        return this.m_nameKey;
    }

    public final Map<String, InteractorPageDef> getDataDefMap() {
        return this.m_interactorDataDefMap;
    }

    public final void addFinishablePage(String pageId) {
        this.m_finishablePages.add(pageId);
    }

    public final void addPreviousPage(String pageId) {
        this.m_previousablePages.add(pageId);
    }

    public final boolean isCommitPage(String pageId) {
        return this.m_commitPages.contains(pageId);
    }

    public final void addCommitPage(String pageId) {
        this.m_commitPages.add(pageId);
    }

    public boolean canFinish(String pageId) {
        return this.m_finishablePages.contains(pageId);
    }

    public boolean canPrevious(String pageId) {
        return this.m_previousablePages.contains(pageId);
    }

    public boolean hasStart() {
        return this.m_first != null && this.m_interactorDataDefMap.containsKey(this.m_first);
    }

    public String getStart() {
        return this.m_first;
    }

    public void setStart(String first) {
        this.m_first = first;
    }

    public final String getDescKey() {
        return this.m_descKey;
    }

    public final Map<String, NextOp> getForwardMap() {
        return this.m_forwardMap;
    }

    public void setForwardDependencies(Map<String, Set<String>> depMap) {
        this.m_forwardDepenencies.putAll(depMap);
    }

    public Set<String> getForwardDependencies(String pageId) {
        Set<String> pageDeps = this.m_forwardDepenencies.get(pageId);
        if (pageDeps == null) {
            pageDeps = new HashSet<String>();
            this.m_forwardDepenencies.put(pageId, pageDeps);
        }
        return pageDeps;
    }

    public Set<FieldTester> getForwardValidators(String pageId) {
        Set<FieldTester> validators = this.m_forwardValidators.get(pageId);
        if (validators == null) {
            validators = new HashSet<FieldTester>();
            this.m_forwardValidators.put(pageId, validators);
        }
        return validators;
    }

    public boolean doesFieldExists(String pageId, String fieldId) {
        InteractorPageDef pageDef = this.m_interactorDataDefMap.get(pageId);
        if (pageDef == null) {
            return false;
        }
        return pageDef.doesFieldExit(fieldId);
    }

    public void setPageNext(String pageId, WizardNavigationAction action) {
        this.m_nextActionMap.put(pageId, action);
    }

    public WizardNavigationAction getPageNext(String pageId) {
        WizardNavigationAction nextAction = this.m_nextActionMap.get(pageId);
        if (nextAction == null) {
            return WizardNavigationAction.NEXT;
        }
        return nextAction;
    }
}

