/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.actions.DialogActionOperation;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SimpleActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.CommandLineException;
import com.primavera.database.tools.dbmt.cmd.ConnectionProcessor;
import com.primavera.database.tools.dbmt.cmd.FieldParameterProcessor;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.cmd.InvalidClass;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgument;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgumentValue;
import com.primavera.schema.pmdbs.command._1.TCommand;
import com.primavera.schema.pmdbs.command._1.TConnection;
import com.primavera.schema.pmdbs.command._1.TConstant;
import com.primavera.schema.pmdbs.command._1.TField;
import com.primavera.schema.pmdbs.command._1.TParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineActionObject {
    private static final String PADDING_SPACES = "                                                                                               ";
    private final ActionOperation m_actionLogic;
    private final Set<String> m_validIds = new HashSet<String>();
    private final Set<ArgumentProcessor> m_processors = new HashSet<ArgumentProcessor>();
    private final Set<OptionDescription> m_syntaxHelpers = new HashSet<OptionDescription>();
    private final String m_cmdId;

    public CommandLineActionObject(ActionOperation actionLogic, TCommand command) throws Exception {
        this.m_actionLogic = actionLogic;
        this.m_processors.addAll(CommandLineActionObject.getConstantsFromCommand(command));
        this.m_processors.addAll(CommandLineActionObject.getParamProcessorsFromCommand(this, command));
        this.m_validIds.addAll(CommandLineActionObject.getParamIdsFromCommand(command));
        this.m_syntaxHelpers.addAll(CommandLineActionObject.getSyntaxHelpersFromCommand(command));
        this.m_cmdId = command.getId();
    }

    private static Collection<? extends OptionDescription> getSyntaxHelpersFromCommand(TCommand command) {
        HashSet<OptionDescription> options = new HashSet<OptionDescription>();
        for (Object o : command.getParamOrConnectOrConstant()) {
            if (o instanceof TParameter) {
                TParameter param = (TParameter)o;
                options.add(new OptionDescription(param.getId(), param.getDesc(), param.getValid()));
                continue;
            }
            if (!(o instanceof TConnection)) continue;
            TConnection conn = (TConnection)o;
            options.add(new OptionDescription(conn.getId(), conn.getDesc(), "connect string"));
        }
        return options;
    }

    private static Collection<? extends String> getParamIdsFromCommand(TCommand command) {
        HashSet<String> validIds = new HashSet<String>();
        for (Object o : command.getParamOrConnectOrConstant()) {
            if (o instanceof TParameter) {
                TParameter param = (TParameter)o;
                validIds.add(param.getId());
                continue;
            }
            if (!(o instanceof TConnection)) continue;
            TConnection conn = (TConnection)o;
            validIds.add(conn.getId());
        }
        return validIds;
    }

    public void processCommandLine(Map<String, String> paramMap, Map<String, Map<String, Set<ValueAndProcessor>>> valueMap) throws InteractorDataError, InvalidCommandLineArgument, InvalidCommandLineArgumentValue {
        for (ArgumentProcessor proc : this.m_processors) {
            proc.prepareArgumentValue(paramMap, valueMap);
        }
    }

    public SimpleActionOperation asSimpleAction() {
        if (this.m_actionLogic instanceof SimpleActionOperation) {
            return (SimpleActionOperation)this.m_actionLogic;
        }
        return null;
    }

    public DialogActionOperation asDialogAction() {
        if (this.m_actionLogic instanceof DialogActionOperation) {
            return (DialogActionOperation)this.m_actionLogic;
        }
        return null;
    }

    public WizardActionOperation asWizardAction() {
        if (this.m_actionLogic instanceof WizardActionOperation) {
            return (WizardActionOperation)this.m_actionLogic;
        }
        return null;
    }

    private static Set<? extends ParameterProcessor> getParamProcessorsFromCommand(CommandLineActionObject cmdLineObject, TCommand command) throws Exception {
        HashSet<ParameterProcessor> paramProcs = new HashSet<ParameterProcessor>();
        for (Object o : command.getParamOrConnectOrConstant()) {
            if (o instanceof TParameter) {
                TParameter param = (TParameter)o;
                paramProcs.add(CommandLineActionObject.createBasicParamProcessor(cmdLineObject, param.getId(), param.getField()));
                continue;
            }
            if (!(o instanceof TConnection)) continue;
            TConnection conn = (TConnection)o;
            paramProcs.add(CommandLineActionObject.createConnectionParamProcessor(conn));
        }
        return paramProcs;
    }

    private static ParameterProcessor createConnectionParamProcessor(TConnection conn) throws Exception {
        return new ConnectionProcessor(conn);
    }

    private static ParameterProcessor createBasicParamProcessor(CommandLineActionObject cmdLineObject, String cmdId, List<TField> fields) {
        return new FieldParameterProcessor(cmdLineObject, cmdId, fields);
    }

    private static Collection<? extends ConstantProcessor> getConstantsFromCommand(TCommand command) throws CommandLineException {
        HashSet<ConstantProcessor> constants = new HashSet<ConstantProcessor>();
        for (Object o : command.getParamOrConnectOrConstant()) {
            if (!(o instanceof TConstant)) continue;
            constants.add(new ConstantProcessor((TConstant)o));
        }
        return constants;
    }

    public ActionOperation getActionOperation() {
        return this.m_actionLogic;
    }

    public void validateCommandLine(String[] args) throws InvalidCommandLineArgument {
        for (int i = 1; i < args.length; i += 2) {
            if (this.m_validIds.contains(args[i].substring(1).toLowerCase())) continue;
            throw new InvalidCommandLineArgument(this, args, i);
        }
    }

    static FieldProcessor getFieldProcessor(String processor) {
        if (processor == null) {
            return FieldParameterProcessor.NOOP_FIELD_PROCESSOR;
        }
        try {
            Class<?> cls = Class.forName(processor);
            Object obj = cls.newInstance();
            if (obj instanceof FieldProcessor) {
                return (FieldProcessor)obj;
            }
            throw new InvalidClass(cls);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void printInvalidArgumentMessage(String cmdId, InvalidCommandLineArgument e) {
        System.out.println(e.getLocalizedMessage());
        this.printSyntaxHelp(cmdId);
    }

    public void printInvalidArgumentMessage(String cmdId, InvalidCommandLineArgument e, List<String> descs) {
        System.out.println(e.getLocalizedMessage());
        if (descs != null) {
            for (String msgKey : descs) {
                System.out.println(StringLocalizer.get(msgKey));
            }
        }
        this.printSyntaxHelp(cmdId);
    }

    public void printInvalidArgumentValueMessage(String cmdId, InvalidCommandLineArgumentValue e) {
        System.out.println(e.getLocalizedMessage());
        this.printSyntaxHelp(cmdId);
    }

    private void printSyntaxHelp(String id) {
        int paddingLength = 0;
        for (OptionDescription option : this.m_syntaxHelpers) {
            paddingLength = Math.max(paddingLength, option.getId().length() + option.getValid().length());
        }
        for (OptionDescription option : this.m_syntaxHelpers) {
            int paddingSize = Math.max(0, paddingLength - (option.getId().length() + option.getValid().length()));
            String padding = PADDING_SPACES.substring(0, paddingSize);
            System.out.println("\t-" + option.getId() + " <" + option.getValid() + ">  " + padding + " -- " + option.getDesc());
        }
        System.out.println();
        System.out.println("The format for <connect string> is <username>/<password>@<oracle|sqlserver>:<host>[:<port>]:<instance or database name>");
    }

    public String getCommandId() {
        return this.m_cmdId;
    }

    private static class OptionDescription {
        private final String m_id;
        private final String m_desc;
        private final String m_valid;

        public OptionDescription(String id, String desc, String valid) {
            this.m_id = id;
            this.m_desc = desc;
            this.m_valid = valid;
        }

        public String getDesc() {
            return this.m_desc;
        }

        public String getId() {
            return this.m_id;
        }

        public String getValid() {
            return this.m_valid;
        }
    }

    public static class ValueAndProcessor {
        private final String m_value;
        private final FieldProcessor m_processor;
        private final int m_sequence;

        public ValueAndProcessor(String value, int seq) {
            this(value, null, seq);
        }

        public ValueAndProcessor(String value, FieldProcessor proc, int seq) {
            this.m_value = value;
            this.m_processor = proc == null ? FieldParameterProcessor.NOOP_FIELD_PROCESSOR : proc;
            this.m_sequence = seq;
        }

        public String getProcessedValue(WizardInteractorData data, JobProperties props) throws Exception {
            return this.m_processor.processFieldData(data, this.m_value, props);
        }

        public int getSequence() {
            return this.m_sequence;
        }

        public String getProcessor() {
            String procName = this.m_processor.getClass().getSimpleName();
            if (procName == null || procName.isEmpty()) {
                return "no processor";
            }
            return procName;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    public static class ConstantProcessor
    implements ArgumentProcessor {
        private final String m_page;
        private final String m_field;
        private final String m_value;
        private final FieldProcessor m_processor;

        public ConstantProcessor(TConstant constant) throws CommandLineException {
            this.m_processor = CommandLineActionObject.getFieldProcessor(constant.getProcessor());
            this.m_value = constant.getValue();
            String[] pageAndField = constant.getField().split("/");
            if (pageAndField.length != 2) {
                throw new CommandLineException("Invlalid field specifier: " + constant.getField());
            }
            this.m_page = pageAndField[0];
            this.m_field = pageAndField[1];
        }

        public String getField() {
            return this.m_field;
        }

        public String getValue() {
            return this.m_value;
        }

        @Override
        public void prepareArgumentValue(Map<String, String> paramMap, Map<String, Map<String, Set<ValueAndProcessor>>> valueMap) throws InvalidCommandLineArgument {
            Set<ValueAndProcessor> vAndPSet;
            Map<String, Set<ValueAndProcessor>> pageMap = valueMap.get(this.m_page);
            if (pageMap == null) {
                pageMap = new HashMap<String, Set<ValueAndProcessor>>();
                valueMap.put(this.m_page, pageMap);
            }
            if ((vAndPSet = pageMap.get(this.m_field)) == null) {
                vAndPSet = new HashSet<ValueAndProcessor>();
                pageMap.put(this.m_field, vAndPSet);
            }
            vAndPSet.add(new ValueAndProcessor(this.m_value, this.m_processor, 0));
        }
    }

    public static abstract class ParameterProcessor
    implements ArgumentProcessor {
        protected final String m_id;

        public ParameterProcessor(String id) {
            this.m_id = id;
        }

        public final String getId() {
            return this.m_id;
        }

        protected String getParamValue(Map<String, String> params) throws InvalidCommandLineArgument {
            return params.get(this.getId());
        }
    }

    public static interface ArgumentProcessor {
        public void prepareArgumentValue(Map<String, String> var1, Map<String, Map<String, Set<ValueAndProcessor>>> var2) throws InvalidCommandLineArgument, InvalidCommandLineArgumentValue;
    }
}

