/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionMap;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionObject;
import com.primavera.database.tools.dbmt.cmd.CommandLineException;
import com.primavera.database.tools.dbmt.cmd.UnableToInitializeCommands;
import com.primavera.schema.pmdbs.command._1.TCommand;
import com.primavera.schema.pmdbs.command._1.TCommandSet;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

public class CommandlineUI {
    private static final String TEMP_COMMAND_DEF_FILE = "com/primavera/database/tools/dbmt/cmd/CommandDefinitions.xml";
    private static final String TEMP_COMMAND_DEF_PKG = "com.primavera.schema.pmdbs.command._1";

    public static void initializeActionLogicActions(Application app) throws UnableToInitializeCommands {
        ActionLogicManager alMgr = ActionLogicManagerImpl.inst();
        CommandLineActionMap aoMgr = CommandLineActionMap.inst();
        CommandlineUI.loadCommandLineActionMap(aoMgr, alMgr);
    }

    private static void loadCommandLineActionMap(CommandLineActionMap aoMgr, ActionLogicManager alMgr) throws UnableToInitializeCommands {
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)TEMP_COMMAND_DEF_PKG);
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            InputStream input = ClassLoader.getSystemResourceAsStream(TEMP_COMMAND_DEF_FILE);
            if (input == null) {
                throw new UnableToInitializeCommands("Unable to get stream from resource com/primavera/database/tools/dbmt/cmd/CommandDefinitions.xml");
            }
            Object unmarshalledObject = unmarshaller.unmarshal(input);
            if (unmarshalledObject instanceof JAXBElement) {
                JAXBElement commandSetElement = (JAXBElement)unmarshalledObject;
                TCommandSet commandSet = (TCommandSet)commandSetElement.getValue();
                CommandlineUI.populateCommandLineActionMap(commandSet, aoMgr, alMgr);
            }
        }
        catch (Exception e) {
            DBMTLogger.info(Channel.DEV, "Error loading command line action map", e);
            throw new UnableToInitializeCommands(e);
        }
    }

    private static void populateCommandLineActionMap(TCommandSet commandSet, CommandLineActionMap aoMgr, ActionLogicManager alMgr) throws Exception {
        for (TCommand c : commandSet.getCommands()) {
            try {
                CommandLineActionObject action = new CommandLineActionObject(alMgr.findAction(c.getAction()), c);
                aoMgr.addAction(c.getId(), action);
            }
            catch (CommandLineException e) {
                DBMTLogger.error(Channel.DEV, "Unable to create command line for " + c.getId() + ": " + e.getMessage());
            }
        }
    }
}

