/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationHelper;
import com.primavera.database.tools.dbmt.ApplicationRunner;
import com.primavera.database.tools.dbmt.InvalidDBMTCommandLine;
import com.primavera.database.tools.dbmt.actions.DialogRunnerFactory;
import com.primavera.database.tools.dbmt.actions.WizardRunnerFactory;
import com.primavera.database.tools.dbmt.cmd.InitializationException;
import com.primavera.database.tools.dbmt.gui.ApplicationUI;
import com.primavera.database.tools.dbmt.gui.DefaultGuiDialogRunnerFactory;
import com.primavera.database.tools.dbmt.gui.DefaultGuiFrameWizardRunnerFactory;
import com.primavera.database.tools.dbmt.gui.LayoutManager;
import com.primavera.database.tools.dbmt.gui.util.LookAndFeelUtil;
import com.primavera.database.tools.dbmt.xml.util.LogFileUtil;
import java.io.File;
import javax.swing.UIManager;

public class ActionApplicationRunner
implements ApplicationRunner {
    private String m_actionName;

    public ActionApplicationRunner() {
        LookAndFeelUtil.setLookAndFeelAndUIDefaults();
    }

    @Override
    public void initializeLogging() {
        DBMTLogger.LogLevel devLogLevel = LogFileUtil.getDevLogLevel();
        DBMTLogger.addAppender(DBMTLogger.LOG4J_APPENDER);
        DBMTLogger.addAppender(DBMTLogger.CONSOLE_APPENDER);
        DBMTLogger.addChannel(Channel.DEV);
        DBMTLogger.addChannel(Channel.USER);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.INFO);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.CONSOLE_APPENDER, devLogLevel);
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LogFileUtil.getLogFileName());
        DBMTLogger.info(Channel.DEV, "Look and feel is " + UIManager.getSystemLookAndFeelClassName());
    }

    @Override
    public void processCmdLineParameters(String[] args) throws InvalidDBMTCommandLine {
        if (args.length == 0) {
            throw new InvalidDBMTCommandLine();
        }
        this.m_actionName = args[0];
    }

    @Override
    public void initialize(Application app) throws InitializationException {
    }

    @Override
    public void start(Application app) {
        LayoutManager.addFromProperty("dbmt.layout.resource");
        ApplicationUI.initializeActionLogicActions(app);
        ActionOperation action = ActionLogicManagerImpl.inst().findAction(this.m_actionName);
        if (action == null) {
            DBMTLogger.error(Channel.DEV, "No action found at " + this.m_actionName);
            return;
        }
        try {
            action.perform();
        }
        catch (ActionFailed e) {
            e.printStackTrace();
        }
        ApplicationHelper.writeApplicationState();
    }

    @Override
    public DialogRunnerFactory createDialogRunnerFactory() {
        return new DefaultGuiDialogRunnerFactory();
    }

    @Override
    public WizardRunnerFactory createWizardRunnerFactory() {
        return new DefaultGuiFrameWizardRunnerFactory();
    }
}

