/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidWizardPageData;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.gui.DefaultGuiWizardRunner;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JRootPane;

public class DefaultDialogGuiWizardRunner
extends DefaultGuiWizardRunner {
    private final JDialog m_dialog = new JDialog();

    public DefaultDialogGuiWizardRunner(WizardInteractorData data, String actionPath) {
        super(data, actionPath);
        this.layoutDialog(data, actionPath);
    }

    @Override
    protected Window getIconTarget() {
        return this.m_dialog.getOwner();
    }

    @Override
    protected boolean invokeWindow() {
        this.m_dialog.pack();
        this.m_dialog.setModal(true);
        this.m_dialog.setVisible(true);
        return this.isAccept();
    }

    @Override
    protected Container getContentPane() {
        return this.m_dialog.getContentPane();
    }

    @Override
    protected JRootPane getRootPane() {
        return this.m_dialog.getRootPane();
    }

    @Override
    protected void setTitle(String titleString) {
        this.m_dialog.setTitle(titleString);
    }

    @Override
    public JDialog getWindow() {
        return this.m_dialog;
    }

    @Override
    protected Action createCancleAction() {
        return new CancelAction(WizardNavigationAction.CANCEL);
    }

    @Override
    protected Action createFinishAction() {
        return new FinishAction(WizardNavigationAction.FINISH);
    }

    private class FinishAction
    extends AbstractAction {
        private static final long serialVersionUID = -4135256610091627735L;

        public FinishAction(WizardNavigationAction action) {
            super(action.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String errorMessage = DefaultDialogGuiWizardRunner.this.getAction().tryToFinish(DefaultDialogGuiWizardRunner.this.getRunner(), DefaultDialogGuiWizardRunner.this.getData(), DefaultDialogGuiWizardRunner.this.m_jobProps, DefaultDialogGuiWizardRunner.this.topPage());
            if (errorMessage == null) {
                DefaultDialogGuiWizardRunner.this.accept();
                DefaultDialogGuiWizardRunner.this.getWindow().dispose();
            } else {
                DefaultDialogGuiWizardRunner.this.displayMessage(errorMessage);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -3189148781292018917L;

        public CancelAction(WizardNavigationAction action) {
            super(action.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.cancelCurrentJobs();
                DefaultDialogGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                while (!DefaultDialogGuiWizardRunner.this.firstPage()) {
                    String topPage = DefaultDialogGuiWizardRunner.this.topPage();
                    DefaultDialogGuiWizardRunner.this.popPage();
                    try {
                        DefaultDialogGuiWizardRunner.this.getAction().undoPage(DefaultDialogGuiWizardRunner.this.getRunner(), DefaultDialogGuiWizardRunner.this.getData(), DefaultDialogGuiWizardRunner.this.m_jobProps, DefaultDialogGuiWizardRunner.this.topPage(), topPage);
                    }
                    catch (InteractorDataError error) {
                        DBMTLogger.warn(Channel.USER, error.getLocalizedMessage());
                    }
                }
            }
            finally {
                DefaultDialogGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(0));
            }
            DefaultDialogGuiWizardRunner.this.getWindow().dispose();
        }

        private void cancelCurrentJobs() {
            try {
                InteractorData page = DefaultDialogGuiWizardRunner.this.getData().getPageData(DefaultDialogGuiWizardRunner.this.topPage());
                if (page.getDef().doesFieldExit("job-tree")) {
                    JobTreeTypeDef jobTreeDef = (JobTreeTypeDef)page.getDef().getTypeDef("job-tree");
                    jobTreeDef.getJobRunner().cancelJobs();
                }
            }
            catch (InvalidWizardPageData e) {
                DBMTLogger.warn(Channel.DEV, "Unable to find top page: " + DefaultDialogGuiWizardRunner.this.topPage());
            }
        }
    }
}

